package com.huigou.tech.message;

import java.util.Map;

import org.apache.log4j.Logger;

import com.huigou.uasp.tool.mail.EmailSender;
import com.huigou.util.JSONUtil;

/**
 * 邮件发送线程
 * 
 * @author xiexin
 */
public class TechEmailSenderThread implements Runnable {
    private static final Logger logger = Logger.getLogger("tech.message.sender");

    private EmailSender emailSender;

    private String email;

    private String subject;

    private Map<String, Object> param;

    public TechEmailSenderThread(EmailSender emailSender, String email, String subject, Map<String, Object> param) {
        this.emailSender = emailSender;
        this.subject = subject;
        this.email = email;
        this.param = param;
    }

    @Override
    public void run() {
        try {
            emailSender.doSend(email, subject, param);
            logger.info(String.format("%s:%s", email, subject));
            try {
                logger.info(JSONUtil.toString(param));
            } catch (Exception e) {
            }
        } catch (Exception e) {
            logger.error(e);
        }
    }

}
