var sapPriceMasterDataGridManager = null;
$(document).ready(function () {
    initializateUI();
    loadPriceMasterDataListGrid();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

// 加载页码表格
function loadPriceMasterDataListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        // 添加一行表格
        addHandler: function () {
            UICtrl.addGridRow(sapPriceMasterDataGridManager,
                {
                    // 行号加一
                    sequence: sapPriceMasterDataGridManager.getData().length + 1
                }
            );
        },
        // 删除选中的尺码信息
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#sapPriceMasterDataListGrid');
            DataUtil.delSelectedRows({
                action: 'sapPriceMasterData/deletePriceMasterDataById.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        }
    });

    // 表格
    sapPriceMasterDataGridManager = UICtrl.grid("#sapPriceMasterDataListGrid", {
        gridManager: null,
        columns: [
            {
                display: "行号", name: "sequence", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {type: 'spinner', min: 1, max: 100, mask: 'nnn'}
            },
            {
                display: "产品物料", name: "matnr", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {type: 'text', required: true}
            },
            {
                display: "价格", name: "kbetr", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {type: 'text', required: true, mask: '99999999999.99'}
            },
            {
                display: "币别", name: "konwaTextView", width: 120, minWidth: 60, type: "String", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {name: 'currency'},
                    textField: 'konwaTextView',
                    valueField: 'konwa',
                    required: true,
                    render: function (item) {
                        return item.konwaTextView;
                    }
                },

            },
            {
                display: "条件单位", name: "kmein", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {type: 'text', required: true}
            },
            {
                display: "有限期自", name: "datab", width: 100, minWidth: 60, type: "data", align: "left",
                editor: {type: 'date', required: true}
            },
            {
                display: "有限截止日", name: "datbi", width: 100, minWidth: 60, type: "data", align: "left",
                editor: {
                    type: 'date', required: true,
                    render: function (data) {
                        if (data.datbi == null) {
                            data.datbi = '9999-12-31'
                        }
                        return data.datbi;
                    }
                },

            },
        ],
        dataAction: "server",
        url: web_app.name + '/sapPriceMasterData/slicedPriceMasterDataItemList.ajax',
        parms: {priceMasterDataId: getId},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "98%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(sapPriceMasterDataGridManager);
}

//获取数据保存的参数
function getExtendedData(processAction) {
    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
        //不验证
        $('#submitForm').attr('check', false);
    }
    const isAllData = $('#oldId') || !getId();
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#sapPriceMasterDataListGrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: isAllData
        });
        if (!datas) {
            return false;
        }
        extendedData.priceMasterDataItem = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

function setId(value) {
    $('#id').val(value);
    var _grid = UICtrl.getGridManager('#sapPriceMasterDataListGrid');
    _grid.options.parms.id = value;
}

function getId() {
    if ($("#id").val() == null)
        return 0;
    else
        return $("#id").val();
}

/**
 * 刷新表格
 */
function reloadGrid(obj) {
    sapPriceMasterDataGridManager.loadData();
}
