﻿//是否开启联动事件
// var isDetail=false;

//定义生成表格的参数对象
var bomObj={
	parms:{},
	node:"",
	url:"",
	columns:[
		{ display: "物料", name: "materialName", width: 140, minWidth: 60, type: "string", align: "left" },
		{ display: "物料数量", name: "materialNumber", width: 120, minWidth: 60, type: "string", align: "left" },
		{ display: "产品", name: "productId", width: 120, minWidth: 60, type: "string", align: "left" }
	]
}
var technologyObj={
	parms:{},
	node:"technologyGrid",
	url:"slicedTechnologyList",
	gridManager:null,
	primaryKey:null,
	columns:[
		{display: "工艺路线名称", name: "technologyName", width: 140, minWidth: 60, type: "string", align: "left",
			editor: {
				type: 'text',
				required: true
			}
		}
	],
	linkage:function (data){
		let key = this.primaryKey;
		let val = data.Rows.length>0?data.Rows[0][key]:-1; // 获取选中行
		processObj.parms = { [key]: val };
		processBomObj.parms = { [key]: val };
		if(processObj.gridManager==null){
			loadGrid(processObj);
			loadGrid(processBomObj);
		}else {
				reloadGrid(processObj);
				reloadGrid(processBomObj);
		}

	}
}
var processObj={
	parms:{},
	node:"processGrid",
	url:"slicedTechnologyProcessList",
	gridManager:null,
	columns:[
		{
			display: "工序名称", name: "processName", width: 120, minWidth: 60, type: "string", align: "left",
			editor: {
				required: true, type: "select",
				data: {
					type: 'system',
					name: "processNameGroup",
					back: {
						processId: "processId",
						processName: "processName",
						processType: "processType",
						processTypeTextView: "processTypeTextView",
						workHours: "workHours",
						processContent: "processContent",
						processRemark: "processRemark",
					}
				},
			}
		},
		{
			display: "工序类别",
			name: "processTypeTextView",
			width: 120,
			minWidth: 60,
			type: "string",
			align: "left",
			/*editor : {
                type : 'combobox',
                data : $("#processType").combox('getJSONData'),
                required : true,
                valueField : 'processType'
            }*/
		},
		{
			display: "工时", name: "workHours", width: 120, minWidth: 60, type: "number", align: "left",
			/*editor: {
                required: true,
                type: 'text',
                mask: 'positiveMoney'
            }*/
		},
		{
			display: "工序内容", name: "processContent", width: 180, minWidth: 60, type: "string", align: "left",
			/*editor: {
                required: true,
                type: 'text'
            }*/
		},
		{
			display: "工序说明", name: "processRemark", width: 180, minWidth: 60, type: "string", align: "left",
			/*editor: {
                required: true,
                type: 'text'
            }*/
		}
	]
}

var processBomObj={
	parms:{},
	node:"processBomGrid",
	url:"slicedProcessMaterialList",
	primaryKey:null,
	columns:[
		{ display: "物料", name: "materialName", width: 140, minWidth: 60, type: "string", align: "left",
			editor: {
				required: true, type: "select",
				data: {
					type: 'system',
					name: "sapMaterialSelect",
					back: {
						materialId: "materialId",
						materialName:"materialName",
						materialUnit:"materialUnit",
						materialJson:"materialJson",
					}
				},
			}
		},
		{ display: "SAP物料详细信息", name: "materialJson", width: 140, minWidth: 60, type: "string", align: "left" },
		{ display: "使用的物料数量", name: "materialNumber", width: 120, minWidth: 60, type: "string", align: "left" ,
			editor: {
                required: true,
                type: 'text',
                mask: 'positiveMoney'
            }
		},
		{ display: "物料计量单位", name: "materialUnit", width: 120, minWidth: 60, type: "string", align: "left" }
	]
}

//创建表格（参数、列、插入的节点、请求地址）
function loadGrid(obj) {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler: function () {
			UICtrl.addGridRow(obj.gridManager);
		},
		deleteHandler: function () {
			var _grid = UICtrl.getGridManager('#'+obj.node);
			_grid.deleteSelectedRow();//删除选定节点
		}
	});
	obj.gridManager =  UICtrl.grid("#"+obj.node, {
		columns: obj.columns,
		dataAction: "server",
		url: web_app.name +'/proofingTechnologyRelevancy/'+obj.url+'.ajax',
		parms:obj.parms,
		pageSize: 10,
		toolbar: toolbarOptions,
		usePager: true,
		enabledEdit: true,
		width: "100%",
		height: 400,
		heightDiff: -8,
		checkbox: true,
		fixedCellHeight: true,
		selectRowButtonOnly: true,
		onSuccess: function (data){
			if(obj.linkage!=null){
				obj.linkage(data)
			}
		}
	});
	UICtrl.setSearchAreaToggle(obj.gridManager);

}


//根据产品编号展示产品的艺表格
function showTechnologyTable(parms,technologyKey,processKey){
	// isDetail=false;
	technologyObj.primaryKey=technologyKey
	processObj.primaryKey=processKey
	technologyObj.parms = parms;
	 if(technologyObj.gridManager==null) {
		 loadGrid(technologyObj);
	 }{
		reloadGrid(technologyObj);
	}
}


$(document).ready(function() {
	// technologyClickRequestProcess();
	UICtrl.layout("#layout",{
		leftWidth:2,
		rightWidth:4,
	})
});


/**
 * 刷新表格
 */
function reloadGrid(obj) {
	if(obj === undefined){
		return;
	}
	obj.gridManager.options.parms=obj.parms;
	obj.gridManager.loadData();
}




// /**
//  * 根据选定的technology列获取对应的process
//  * 冒泡机制永远都会先执行此点击事件，需要让平台内置事件先执行来获取行id
//  */
// function technologyClickRequestProcess(){
// 	$(document).on('click', '#technology .l-grid-row', function(event) {
// 		setTimeout(function() {
// 			if(isDetail)return;
// 			debugger
// 			let result = DataUtil.getUpdateRow(technologyObj.gridManager); // 获取选中行
// 			processObj.parms = { technologyId: result.technologyId };
// 			processBomObj.parms = { technologyId: result.technologyId };
// 			if (processObj.gridManager != null) {
// 				reloadGrid(processObj);
// 				reloadGrid(processBomObj);
// 			} else {
// 				loadProofingApplyGrid(processObj);
// 				loadProofingApplyGrid(processBomObj);
// 			}
// 		}, 0);
// 	});
//
// }

/**
 * 获取编辑表格中的数据
 * @returns {{}|boolean}
 */
function getTableResult(){
	let technologyResult = DataUtil.getUpdateRow(technologyObj.gridManager); // 获取选中行

	let processResult =processObj.gridManager.getSelectedRows();

	let processMaterialResult =  processBomObj.gridManager.getSelectedRows();

	if(!technologyResult){
		Public.tip("请选择工艺！")
		return false;
	}else if(processResult.length<1){
		Public.tip("请选择工序！")
		return false;
	}else if(processMaterialResult.length<1){
		Public.tip("请选择工序物料！")
		return false;
	}
	var extendedData = {};
	extendedData.technology = Public.encodeJSONURI(technologyResult);
	extendedData.process = Public.encodeJSONURI(processResult);
	extendedData.processMaterial = Public.encodeJSONURI(processMaterialResult);
	return extendedData;
}

function getTableDateAll(obj){
	let result = DataUtil.getGridData({
		gridManager: obj.gridManager,
		isAllData: true
	});
	return result;
}