package com.huigou.topsun.proofing.controller;

import com.huigou.topsun.proofing.application.*;
import com.huigou.topsun.proofing.domain.proofingApply.query.ProofingApplyProcessMaterialQueryRequest;
import com.huigou.topsun.proofing.domain.proofingApply.query.ProofingApplyProcessQueryRequest;
import com.huigou.topsun.proofing.domain.proofingApply.query.ProofingApplyTechnologyQueryRequest;
import com.huigou.topsun.proofing.domain.proofingMake.query.ProofingMakeProcessMaterialQueryRequest;
import com.huigou.topsun.proofing.domain.proofingMake.query.ProofingMakeProcessQueryRequest;
import com.huigou.topsun.proofing.domain.proofingMake.query.ProofingMakeTechnologyQueryRequest;
import com.huigou.topsun.technology.application.TechnologyApplication;
import com.huigou.topsun.technology.application.TechnologyProcessApplication;
import com.huigou.topsun.technology.domain.model.ProcessMaterialItem;
import com.huigou.topsun.technology.domain.query.TechnologyQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@ControllerMapping("/proofingTechnologyRelevancy")
public class ProofingTechnologyRelevancyController extends CommonController {
    protected String getPagePath() {
        return "/biz/topsun/proofing/";
    }


    @Autowired
    TechnologyApplication technologyApplication;
    @Resource
    private TechnologyProcessApplication technologyProcessApplication;
    @Autowired
    ProofingApplyTechnologyApplication proofingApplyTechnologyApplication;
    @Autowired
    ProofingApplyProcessApplication proofingApplyProcessApplication;
    @Autowired
    ProofingMakeTechnologyApplication proofingMakeTechnologyApplication;
    @Autowired
    ProofingMakeProcessApplication proofingMakeProcessApplication;
    @Autowired
    ProofingApplyProcessMaterialApplication proofingApplyProcessMaterialApplication;
    @Autowired
    ProofingMakeProcessMaterialApplication proofingMakeProcessMaterialApplication;


    /**
     * 展示工艺
     * @return
     */
    public String slicedTechnologyList(){
        SDO sdo = this.getSDO();
        TechnologyQueryRequest queryRequest = sdo.toQueryRequest(TechnologyQueryRequest.class);
        ProofingApplyTechnologyQueryRequest proofingApplyTechnologyQueryRequest = sdo.toQueryRequest(ProofingApplyTechnologyQueryRequest.class);
        ProofingMakeTechnologyQueryRequest proofingMakeTechnologyQueryRequest = sdo.toQueryRequest(ProofingMakeTechnologyQueryRequest.class);
        Map<String, Object> map = new HashMap<>();
        //判断需要展示产品工艺还是打样表中工艺
        if(!StringUtil.isBlank(queryRequest.getProductId())){
            map = technologyApplication.slicedTechnologyList(queryRequest);
        }else if(!StringUtil.isBlank(proofingApplyTechnologyQueryRequest.getProofingApplyId())){
            map = proofingApplyTechnologyApplication.slicedProofingApplyTechnology(proofingApplyTechnologyQueryRequest);
        }else  if(!StringUtil.isBlank(proofingMakeTechnologyQueryRequest.getProofingMakeId())){
            map=proofingMakeTechnologyApplication.slicedProofingMakeTechnology(proofingMakeTechnologyQueryRequest);
        }
        return toResult(map);
    }


    /**
     * 展示工序
     * @return
     */
    public String slicedTechnologyProcessList(){
        SDO sdo = this.getSDO();
        String technologyId = sdo.getString("technologyId");
        ProofingApplyProcessQueryRequest proofingApplyProcessQueryRequest = sdo.toQueryRequest(ProofingApplyProcessQueryRequest.class);
        ProofingMakeProcessQueryRequest proofingMakeProcessQueryRequest = sdo.toQueryRequest(ProofingMakeProcessQueryRequest.class);
        //判断需要展示产品工序还是打样表中工序
        if(!StringUtil.isBlank(proofingApplyProcessQueryRequest.getProofingApplyTechnologyId())){
           return toResult(proofingApplyProcessApplication.slicedProofingApplyProcess(proofingApplyProcessQueryRequest));
        }else if(!StringUtil.isBlank(technologyId)){
            return packGridDataAndResult(technologyProcessApplication.slicedTechnologyProcessList(technologyId));
        }else  if(!StringUtil.isBlank(proofingMakeProcessQueryRequest.getProofingMakeTechnologyId())){
            return toResult(proofingMakeProcessApplication.slicedProofingMakeProcess(proofingMakeProcessQueryRequest));
        }
        return toResult(null);
    }


    /**
     * 展示工序
     * @return
     */
    public String slicedProcessMaterialList(){
        SDO sdo = this.getSDO();
        String technologyId = sdo.getString("technologyId");
        ProofingApplyProcessMaterialQueryRequest proofingApplyProcessMaterialQueryRequest = sdo.toQueryRequest(ProofingApplyProcessMaterialQueryRequest.class);
        ProofingMakeProcessMaterialQueryRequest proofingMakeProcessMaterialQueryRequest = sdo.toQueryRequest(ProofingMakeProcessMaterialQueryRequest.class);

        //判断需要展示产品工序还是打样表中工序
        if(!StringUtil.isBlank(proofingApplyProcessMaterialQueryRequest.getProofingApplyTechnologyId())){
            return toResult(proofingApplyProcessMaterialApplication.slicedProofingApplyProcessMaterial(proofingApplyProcessMaterialQueryRequest));
        }else if(!StringUtil.isBlank(technologyId)){
            return toResult(tempData());
        }else  if(!StringUtil.isBlank(proofingMakeProcessMaterialQueryRequest.getProofingMakeTechnologyId())){
            return toResult(proofingMakeProcessMaterialApplication.slicedProofingMakeProcessMaterial(proofingMakeProcessMaterialQueryRequest));
        }
        return toResult(null);
    }

    public Map<String,Object> tempData(){
        Map<String, Object> map = new HashMap<>();
        List<ProcessMaterialItem> list = new ArrayList<>();
        for (int i = 0; i < 5; i++) {
            ProcessMaterialItem processMaterialItem = new ProcessMaterialItem();
            processMaterialItem.setMaterialId("测试id"+i);
            processMaterialItem.setMaterialName("测试name"+i);
            processMaterialItem.setMaterialNumber(Double.valueOf(i));
            processMaterialItem.setProcessId("process_id"+i);
            processMaterialItem.setMaterialJson("测试material"+i);
            processMaterialItem.setMaterialUnit("测试Unit"+i);
            list.add(processMaterialItem);
        }
        map.put("Rows",list);
        return map;
    }

}
