package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.CustomerDebtContactApplication;
import com.huigou.topsun.customer.domain.CustomerDebtContact;
import com.huigou.topsun.customer.domain.query.CustomerDebtContactQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerDebtContactVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2023/12/19
 * description:
 *    催货款通知邮箱
 */
@Controller
@ControllerMapping("/customerDebtContact")
public class CustomerDebtContactController extends CommonController {
    @Autowired
    private CustomerDebtContactApplication customerDebtContactApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/custcomer/";
    }

    /**
     * 跳转到催货款通知邮箱展示页面
     */
    public String forwardCustomerDebtContactList() {
        return forward("customerDebtContactList");
    }

    /**
     * 跳转到催货款通知邮箱新增页面
     */
    public String saveCustomerDebtContactDetail() {
        return forward("customerDebtContactDetail");
    }
    /**
     * 获取催货款通知邮箱
     */
    public String slicedCustomerDebtContactList() {
        SDO sdo = this.getSDO();
        String customerId = sdo.getString("customerId");
        String customerEmailType = sdo.getString("customerEmailType");
        return packGridDataAndResult(customerDebtContactApplication.getCustomerDebtContactList(customerId,customerEmailType));
    }

    /**
     * 新增催货款通知邮箱
     */
    public String saveCustomerDebtContact() {
        SDO sdo = this.getSDO();
        CustomerDebtContactVo customerDebtContactVo = sdo.toObject(CustomerDebtContactVo.class);
        CustomerDebtContact customerDebtContact = CustomerDebtContactVo.getCustomerDebtContact(customerDebtContactVo);
        // 获取操作人信息
        String personMemberName = sdo.getOperator().getPersonMemberName();
        String personMemberId = sdo.getOperator().getPersonMemberId();
        customerDebtContact.setCreatedById(personMemberId);
        customerDebtContact.setCreatedByName(personMemberName);
        customerDebtContactVo = customerDebtContactApplication.saveCustomerDebtContact(customerDebtContact);

        return success(customerDebtContactVo);
    }

    /**
     * 删除催货款信息邮箱
     */
    public String deleteCustomerDebtContact() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        customerDebtContactApplication.deleteCustomerDebtContact(ids);
        return success();
    }
}
