package com.huigou.topsun.technology.vo;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * 工序
 * @TableName process
 */
@Data
public class TechnologyProcessVo implements Serializable {
    /**
     * 工艺节点条目ID
     */
    private String technologyProcessId;

    /**
     * 工艺ID
     */
    private String technologyId;

    /**
     * 工序ID
     */
    private String processId;

    /**
     * 资源id
     */
    private String resourceId;

    /**
     * 资源版本
     */
    private String version;

    /**
     * 条目序号
     */
    private Integer sortNum;


    /**
     * 工序名称
     */
    private String processName;

    /**
     * 工序说明
     */
    private String processRemark;

    /**
     * 工时
     */
    private Double workHours;

    /**
     * 工序类别(process_type)
     */
    private String processType;

    /**
     * 工序内容
     */
    private String processContent;

    /**
     * 工序物料id
     */
    private String materialId;

    /**
     * 物料名称
     */
    private String materialName;

    /**
     * 使用的物料数量
     */
    private Double materialNumber;

    /**
     * 物料计量单位
     */
    private String materialUnit;

    /**
     * sap物料相信内容
     */
    private String materialJson;

    public static Process getProcess(TechnologyProcessVo processVo){
        return JSON.parseObject(JSON.toJSONString(processVo),Process.class);
    }

    public static TechnologyProcessVo getProcessVo(Process process){
        return JSON.parseObject(JSON.toJSONString(process), TechnologyProcessVo.class);
    }
}