package com.huigou.topsun.technology.domain.model;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 工序资源
 * @TableName process_resource
 */
@Table(name="process_resource")
@Data
@Entity
public class ProcessResource implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "process_resource_id")
    private String processResourceId;

    /**
     * 所属工序ID
     */
    @Column(name = "technology_process_id")
    private String technologyProcessId;

    /**
     * 使用的资源ID
     */
    @Column(name = "resource_id")
    private String resourceId;

    /**
     * 版本号
     */
    private String version;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProcessResource other = (ProcessResource) that;
        return (this.getProcessResourceId() == null ? other.getProcessResourceId() == null : this.getProcessResourceId().equals(other.getProcessResourceId()))
            && (this.getTechnologyProcessId() == null ? other.getTechnologyProcessId() == null : this.getTechnologyProcessId().equals(other.getTechnologyProcessId()))
            && (this.getResourceId() == null ? other.getResourceId() == null : this.getResourceId().equals(other.getResourceId()))
            && (this.getVersion() == null ? other.getVersion() == null : this.getVersion().equals(other.getVersion()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProcessResourceId() == null) ? 0 : getProcessResourceId().hashCode());
        result = prime * result + ((getTechnologyProcessId() == null) ? 0 : getTechnologyProcessId().hashCode());
        result = prime * result + ((getResourceId() == null) ? 0 : getResourceId().hashCode());
        result = prime * result + ((getVersion() == null) ? 0 : getVersion().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", processResourceId=").append(processResourceId);
        sb.append(", technologyProcessId=").append(technologyProcessId);
        sb.append(", resourceId=").append(resourceId);
        sb.append(", version=").append(version);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}