package com.huigou.topsun.technology.domain.model;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 工序物料关系表
 * @TableName process_material_item
 */
@Table(name="process_material_item")
@Data
@Entity
public class ProcessMaterialItem implements Serializable {
    /**
     * 工艺物料关系ID
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "process_material_item_id")
    private String processMaterialItemId;

    /**
     * 工艺ID
     */
    @Column(name = "technology_process_id")
    private String technologyProcessId;

    /**
     * 物料ID
     */
    @Column(name = "material_id")
    private String materialId;

    /**
     * 物料名称
     */
    @Column(name = "material_name")
    private String materialName;

    /**
     * 使用的物料数量
     */
    @Column(name = "material_number")
    private Double materialNumber;

    /**
     * 物料计量单位
     */
    @Column(name = "material_unit")
    private String materialUnit;

    /**
     * sap物料相信内容
     */
    @Column(name = "material_json")
    private String materialJson;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProcessMaterialItem other = (ProcessMaterialItem) that;
        return (this.getProcessMaterialItemId() == null ? other.getProcessMaterialItemId() == null : this.getProcessMaterialItemId().equals(other.getProcessMaterialItemId()))
            && (this.getTechnologyProcessId() == null ? other.getTechnologyProcessId() == null : this.getTechnologyProcessId().equals(other.getTechnologyProcessId()))
            && (this.getMaterialId() == null ? other.getMaterialId() == null : this.getMaterialId().equals(other.getMaterialId()))
            && (this.getMaterialNumber() == null ? other.getMaterialNumber() == null : this.getMaterialNumber().equals(other.getMaterialNumber()))
            && (this.getMaterialUnit() == null ? other.getMaterialUnit() == null : this.getMaterialUnit().equals(other.getMaterialUnit()))
            && (this.getMaterialJson() == null ? other.getMaterialJson() == null : this.getMaterialJson().equals(other.getMaterialJson()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProcessMaterialItemId() == null) ? 0 : getProcessMaterialItemId().hashCode());
        result = prime * result + ((getTechnologyProcessId() == null) ? 0 : getTechnologyProcessId().hashCode());
        result = prime * result + ((getMaterialId() == null) ? 0 : getMaterialId().hashCode());
        result = prime * result + ((getMaterialNumber() == null) ? 0 : getMaterialNumber().hashCode());
        result = prime * result + ((getMaterialUnit() == null) ? 0 : getMaterialUnit().hashCode());
        result = prime * result + ((getMaterialJson() == null) ? 0 : getMaterialJson().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", processMaterialItemId=").append(processMaterialItemId);
        sb.append(", technologyProcessId=").append(technologyProcessId);
        sb.append(", materialId=").append(materialId);
        sb.append(", materialNumber=").append(materialNumber);
        sb.append(", materialUnit=").append(materialUnit);
        sb.append(", materialJson=").append(materialJson);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}