package com.huigou.topsun.technology.controller;

import com.huigou.cache.DictUtil;
import com.huigou.topsun.technology.application.TechnologyApplication;
import com.huigou.topsun.technology.application.TechnologyProcessApplication;
import com.huigou.topsun.technology.domain.query.TechnologyQueryRequest;
import com.huigou.topsun.technology.vo.TechnologyProcessVo;
import com.huigou.topsun.technology.vo.TechnologyVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/11/23/11:14
 * @Description:
 */
@Controller
@ControllerMapping("/technology")
public class TechnologyController extends CommonController {

    @Resource
    private TechnologyApplication technologyApplication;
    @Resource
    private TechnologyProcessApplication technologyProcessApplication;

    protected String getPagePath() {
        return "/biz/topsun/technology/";
    }


    /**
     * 跳转到查询页面
     * @return
     */
    public String forwardTechnologyList(){
        Map<String, String> processType = DictUtil.getDictionary("processType");
        this.putAttribute("processType",processType);
        return forward("technologyList");
    }

    /**
     * 查询数据列表
     * @return
     */
    public String slicedTechnologyList(){
        SDO sdo = this.getSDO();
        TechnologyQueryRequest queryRequest = sdo.toQueryRequest(TechnologyQueryRequest.class);
        return toResult(technologyApplication.slicedTechnologyList(queryRequest));
    }

    public String queryTechnologyByProduct(){
        SDO sdo = this.getSDO();
        List<String> productIds = sdo.getStringList("ids");
        TechnologyQueryRequest queryRequest = sdo.toQueryRequest(TechnologyQueryRequest.class);
        Map<String, Object> map = new HashMap<>();
        if (!CollectionUtils.isEmpty(productIds)){
            String productId = "";
            if (productIds.size() >1){
                productId = String.join(",", productIds);
            }else {
                productId = productIds.get(0);
            }
            queryRequest.setProductId(productId);
            map = technologyApplication.queryTechnologyByProduct(queryRequest);
        }
        return toResult(map);
    }

    /**
     * 保存工艺
     * @return
     */
    public String saveTechnology(){
        SDO sdo = this.getSDO();
        TechnologyVo technologyVo = sdo.toObject(TechnologyVo.class);
        List<TechnologyProcessVo> processList = sdo.getList("processList", TechnologyProcessVo.class);
        if (StringUtil.isNotBlank(technologyVo.getTechnologyId())){
            technologyProcessApplication.updateTechnologyProcessVoList(technologyVo.getTechnologyId(),processList);
        }else {
            technologyVo = technologyApplication.saveTechnology(technologyVo);
            technologyProcessApplication.saveTechnologyProcessVoList(technologyVo.getTechnologyId(),processList);
        }
        return success(technologyVo);
    }

    /**
     * 修改工艺
     * @return
     */
    public String updateTechnology(){
        SDO sdo = this.getSDO();
        TechnologyVo technologyVo = sdo.toObject(TechnologyVo.class);
        technologyApplication.updateTechnologyVo(technologyVo);
        List<TechnologyProcessVo> processList = sdo.getList("processList", TechnologyProcessVo.class);
        technologyProcessApplication.updateTechnologyProcessVoList(technologyVo.getTechnologyId(),processList);
        return success(technologyVo);
    }

    /**
     * 删除工艺
     * @return
     */
    public String deleteTechnologyByTechnologyId(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        technologyApplication.deleteTechnology(ids);
        return success();
    }

    /**
     *  工艺新增明细
     * @return
     */
    public String addTechnologyDetail(){
        return forward("technologyDetail");
    }

    /**
     *  查看工艺明细
     * @return
     */
    public String showTechnologyDetail(){
        SDO sdo = this.getSDO();
        String technologyId = sdo.getString("technologyId");
        this.putAttribute("productName","1");
        TechnologyVo technologyVo = technologyApplication.findTechnologyByTechnologyIdId(technologyId);
        return forward("technologyDetail",technologyVo);
    }
}
