package com.huigou.topsun.technology.controller;

import com.huigou.cache.DictUtil;
import com.huigou.topsun.technology.application.ProcessApplication;
import com.huigou.topsun.technology.domain.query.ProcessQueryRequest;
import com.huigou.topsun.technology.vo.ProcessVo;
import com.huigou.topsun.technology.vo.TechnologyVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/11/23/15:48
 * @Description:
 */
@Controller
@ControllerMapping("/process")
public class ProcessController extends CommonController {
    protected String getPagePath() {
        return "/biz/topsun/technology/";
    }

    @Resource
    private ProcessApplication processApplication;

    public String forwardProcessList(){
        Map<String, String> processType = DictUtil.getDictionary("processType");
        this.putAttribute("processType",processType);
        return forward("processList");
    }

    public String slicedProcessList(){
        SDO sdo = this.getSDO();
        ProcessQueryRequest queryRequest = sdo.toQueryRequest(ProcessQueryRequest.class);
        return toResult(processApplication.slicedProcessList(queryRequest));
    }

    /**
     *  工序新增明细
     * @return
     */
    public String addProcessDetail(){
        return forward("processDetail");
    }

    /**
     * 保存工序
     * @return
     */
    public String saveProcess(){
        SDO sdo = this.getSDO();
        ProcessVo processVo = sdo.toObject(ProcessVo.class);
        processVo = processApplication.saveProcess(processVo);
        return success(processVo);
    }

    /**
     *  查看工序明细
     * @return
     */
    public String showProcessDetail(){
        SDO sdo = this.getSDO();
        String processId = sdo.getString("processId");
        ProcessVo processVo = processApplication.findProcessByProcessId(processId);
        return forward("processDetail",processVo);
    }

    public String deleteProcess(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        processApplication.deleteProcessByProcessIds(ids);
        return success();
    }

}
