package com.huigou.topsun.technology.application.impl;

import com.huigou.topsun.technology.application.ProcessResourceApplication;
import com.huigou.topsun.technology.domain.model.ProcessResource;
import com.huigou.topsun.technology.repository.ProcessResourceRepository;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
* @author 16508
* @description 针对表【process_resource(工序资源)】的数据库操作Service实现
* @createDate 2023-11-22 11:04:03
*/
@Service
public class ProcessResourceApplicationImpl implements ProcessResourceApplication {
    @Resource
    private ProcessResourceRepository processResourceRepository;

    @Override
    public ProcessResource saveProcessResource(ProcessResource processResource) {
        return processResourceRepository.saveAndFlush(processResource);
    }

    @Override
    public void deleteByTechnologyProcessId(String technologyProcessId) {
        List<ProcessResource> processResourceList = processResourceRepository.findByTechnologyProcessId(technologyProcessId);
        processResourceRepository.delete(processResourceList);
    }
}




