package com.huigou.topsun.technology.application.impl;

import com.huigou.topsun.technology.application.ProcessMaterialItemApplication;
import com.huigou.topsun.technology.domain.model.ProcessMaterialItem;
import com.huigou.topsun.technology.repository.ProcessMaterialItemRepository;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
* @author 16508
* @description 针对表【process_material_item(工序物料关系表)】的数据库操作Service实现
* @createDate 2023-11-22 11:04:03
*/
@Service
public class ProcessMaterialItemApplicationImpl implements ProcessMaterialItemApplication {
    @Resource
    private ProcessMaterialItemRepository processMaterialItemRepository;

    @Override
    public ProcessMaterialItem saveProcessMaterialItem(ProcessMaterialItem processMaterialItem) {
        return processMaterialItemRepository.save(processMaterialItem);
    }

    @Override
    public void deleteByTechnologyProcessId(String technologyProcessId) {
        List<ProcessMaterialItem> materialItemList = processMaterialItemRepository.findByTechnologyProcessId(technologyProcessId);
        processMaterialItemRepository.delete(materialItemList);
    }
}




