package com.huigou.topsun.technology.application;


import com.huigou.topsun.technology.domain.model.TechnologyProcess;
import com.huigou.topsun.technology.domain.query.TechnologyProcessQueryRequest;
import com.huigou.topsun.technology.vo.TechnologyProcessVo;

import java.util.List;
import java.util.Map;

/**
* @author 16508
* @description 针对表【technology_process(工艺工序关系表)】的数据库操作Service
* @createDate 2023-11-22 11:04:03
*/
public interface TechnologyProcessApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/technology/technologyProcess.xml";
    List<Map<String, Object>> slicedTechnologyProcessList(String technologyId);

    void saveTechnologyProcessVoList(String technologyId, List<TechnologyProcessVo> technologyProcessList);

    void updateTechnologyProcessVoList(String technologyId, List<TechnologyProcessVo> processList);

    List<TechnologyProcess> findByTechnologyId(String technologyId);

    void deleteByTechnologyProcessIds(List<String> technologyProcessIds);
}
