package com.huigou.topsun.quotation.vo;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 报价单明细
 * @TableName quotation_item
 */
@Data
public class QuotationItemVo implements Serializable {
    /**
     * 
     */
    private String quotationItemId;

    /**
     * 报价单id
     */
    private String quotationId;

    /**
     * 序号/行项目
     */
    private Integer sequence;

    /**
     * 产品id
     */
    private String productId;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 币别（码表currency）
     */
    private String currency;

    /**
     * 备注
     */
    private String remark;

    /**
     * 预估价
     */
    @Column(name = "presale_price")
    private BigDecimal presalePrice;

    /**
     * 正式价格
     */
    private BigDecimal formalPrice;

    private String productCode;

    private String productName;

    private String productUnit;
}