package com.huigou.topsun.quotation.domain.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 报价单明细
 * @TableName quotation_item
 */
@Table(name="quotation_item")
@Data
@Entity
public class QuotationItem implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "quotation_item_id")
    private String quotationItemId;

    /**
     * 报价单id
     */
    @Column(name = "quotation_id")
    private String quotationId;

    /**
     * 序号/行项目
     */
    private Integer sequence;

    /**
     * 产品id
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 币别（码表currency）
     */
    private String currency;

    /**
     * 备注
     */
    private String remark;

    /**
     * 预估价
     */
    @Column(name = "presale_price")
    private BigDecimal presalePrice;

    /**
     * 正式价格
     */
    @Column(name = "formal_price")
    private BigDecimal formalPrice;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        QuotationItem other = (QuotationItem) that;
        return (this.getQuotationItemId() == null ? other.getQuotationItemId() == null : this.getQuotationItemId().equals(other.getQuotationItemId()))
            && (this.getQuotationId() == null ? other.getQuotationId() == null : this.getQuotationId().equals(other.getQuotationId()))
            && (this.getSequence() == null ? other.getSequence() == null : this.getSequence().equals(other.getSequence()))
            && (this.getProductId() == null ? other.getProductId() == null : this.getProductId().equals(other.getProductId()))
            && (this.getPrice() == null ? other.getPrice() == null : this.getPrice().equals(other.getPrice()))
            && (this.getCurrency() == null ? other.getCurrency() == null : this.getCurrency().equals(other.getCurrency()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getPresalePrice() == null ? other.getPresalePrice() == null : this.getPresalePrice().equals(other.getPresalePrice()))
            && (this.getFormalPrice() == null ? other.getFormalPrice() == null : this.getFormalPrice().equals(other.getFormalPrice()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getQuotationItemId() == null) ? 0 : getQuotationItemId().hashCode());
        result = prime * result + ((getQuotationId() == null) ? 0 : getQuotationId().hashCode());
        result = prime * result + ((getSequence() == null) ? 0 : getSequence().hashCode());
        result = prime * result + ((getProductId() == null) ? 0 : getProductId().hashCode());
        result = prime * result + ((getPrice() == null) ? 0 : getPrice().hashCode());
        result = prime * result + ((getCurrency() == null) ? 0 : getCurrency().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getPresalePrice() == null) ? 0 : getPresalePrice().hashCode());
        result = prime * result + ((getFormalPrice() == null) ? 0 : getFormalPrice().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", quotationItemId=").append(quotationItemId);
        sb.append(", quotationId=").append(quotationId);
        sb.append(", sequence=").append(sequence);
        sb.append(", productId=").append(productId);
        sb.append(", price=").append(price);
        sb.append(", currency=").append(currency);
        sb.append(", remark=").append(remark);
        sb.append(", presalePrice=").append(presalePrice);
        sb.append(", formalPrice=").append(formalPrice);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}