package com.huigou.topsun.quotation.controller;

import com.huigou.topsun.quotation.application.QuotationItemApplication;
import com.huigou.topsun.quotation.vo.QuotationItemVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @Auther: xin.lu
 * @Date: 2023/11/28/16:10
 * @Description:
 */
@Controller
@ControllerMapping("quotationItem")
public class QuotationItemController extends CommonController {
    @Resource
    private QuotationItemApplication quotationItemApplication;
    public String findQuotationItems(){
        SDO sdo = this.getSDO();
        String quotationId = sdo.getString("quotationId");
        return packGridDataAndResult(quotationItemApplication.findQuotationItemByQuotationId(quotationId));
    }

    public String queryQuotationItemList(){
        SDO sdo = this.getSDO();
        String quotationId = sdo.getString("quotationId");
        List<QuotationItemVo> quotationItemVos = new ArrayList<>();
        if (!StringUtil.isBlank(quotationId)){
            quotationItemVos = quotationItemApplication.queryQuotationItemList(quotationId);
        }
        return packGridDataAndResult(quotationItemVos);
    }
}
