package com.huigou.topsun.proofing.domain.vo;


import lombok.Data;

import javax.persistence.Column;
import java.util.Date;

/**
 * 样品制作表展示
 */
@Data
public class ProofingMakeVo{

    /**
     * 制作单id
     */

    private String proofingMakeId;

    /**
     * 制作单号
     */
    private String proofingMakeNo;


    /**
     * 申请单的主键id
     * proofing_apply表的主键是id列
     */
    private String id;


    /**
     * 申请单id
     */
    private String proofingApplyId;




    /**
     * 申请单号
     */
    private String proofingApplyNo;

    /**
     * 产品id
     */
    private String productId;

    /**
     * 客户id
     */
    private String customerId;

    /**
     * 版面需求时间
     */
    private Date proofingApplyPageNeedTime;

    /**
     * 完成日期
     */
    private Date proofingApplyCompleteDate;

    /**
     * 中文样品名
     */
    private String proofingApplySampleCnName;

    /**
     * 英文样品名
     */
    private String proofingApplySampleEnName;

    /**
     * 样品版次
     */
    private Integer proofingApplySampleVersion;

    /**
     * 样品规格
     */
    private Integer proofingApplySampleSize;

    /**
     * 样品数量
     */
    private Long proofingApplySampleNum;

    /**
     * 产量情况
     */
    private String proofingApplyOutputSituation;

    /**
     * 产品代号
     */
    private String proofingApplyProductNo;

    /**
     * 打样形式
     */
    private String proofingType;

    /**
     * 版面
     */


    /**
     * 分配方式
     */
    private String proofingApplyAllocationType;

    /**
     * 产品类别
     */

    /**
     * 表面处理
     */
    private String proofingApplySurfaceTreatment;

    /**
     * NG重新打样原因
     */
    private String proofingApplyNgReReason;

    /**
     *申请单状态
     */
    private String proofingApplyApplicationStatus;

    /**
     *测试标准
     */
    private String proofingApplyTestStandard;

    /**
     *颜色种类
     */
    private String colorType;
    /**
     *专
     */
    private String expert;

    /**
     * 网版目数
     */
    private Integer printingPlateNum;

    /**
     *啤版目数
     */
    private Integer beerPlateNum;

    /**
     *模切板目数
     */
    private Integer dieBoardNum;

    //产品打样排版参数方面字段
    /**
     * 模数
     */
    private Integer modulus;

    /**
     * 行数
     */
    private Integer rowNum;

    /**
     * 列数
     */
    private Integer columnNum;

    /**
     * 搭版数
     */
    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */
    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */
    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */
    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */
    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    private Double sheetWidth;

    /**
     * 产品印张设置(product_sheet_conf)
     */
    private String productSheetConf;

}