package com.huigou.topsun.proofing.domain.model.workInstruction;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 作业指导书Loss信息
 * @TableName work_instruction_product_loss
 */
@Table(name="work_instruction_product_loss")
@Entity
@Data
public class WorkInstructionProductLoss implements Serializable {
    /**
     * 产品lossID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY) // 使用自动递增策略
    @Column(name = "product_loss_id")
    private Long productLossId;

    /**
     * 产品最大loss数量
     */
    @Column(name = "product_loss_max")
    private Integer productLossMax;

    /**
     * loss比率(单位%)
     */
    @Column(name = "product_loss_rate")
    private Double productLossRate;

    /**
     * 冗余量
     */
    @Column(name = "product_loss_Redundance")
    private Double productLossRedundance;

    /**
     * 备注信息
     */
    @Column(name = "product_loss_remark")
    private String productLossRemark;

    /**
     * 客户名称
     */
    @Column(name = "customer_name")
    private String customerName;

    /**
     * 新增分段
     */
    @Column(name = "product_add_section")
    private String productAddSection;

    /**
     * 删除分段
     */
    @Column(name = "product_delete_section")
    private String productDeleteSection;

    /**
     * 作业指导书id
     */
    @Column(name = "work_instruction_base_info_id")
    private String workInstructionBaseInfoId;

    private static final long serialVersionUID = 1L;
}