package com.huigou.topsun.proofing.domain.model.workInstruction;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 作业指导书产品外观
 * @TableName work_instruction_prd_looked
 */
@Table(name="work_instruction_prd_looked")
@Entity
@Data
public class WorkInstructionPrdLooked implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "work_instruction_prd_looked_id")
    private String workInstructionPrdLookedId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    private Long productId;

    /**
     * 长;单位cm
     */
    @Column(name = "product_length")
    private Double productLength;

    /**
     * 宽;单位cm
     */
    @Column(name = "product_width")
    private Double productWidth;

    /**
     * 高;单位cm
     */
    @Column(name = "product_height")
    private Double productHeight;

    /**
     * 厚度;单位mm
     */
    @Column(name = "product_thick")
    private Double productThick;

    /**
     * 成品克重;单位g
     */
    @Column(name = "product_weight")
    private Double productWeight;

    /**
     * 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；
     */
    @Column(name = "product_shape")
    private String productShape;

    /**
     * 孔径(单位mm)
     */
    @Column(name = "product_aperture")
    private Double productAperture;

    /**
     * 单层厚(单位丝)
     */
    @Column(name = "product_single_layer")
    private Integer productSingleLayer;

    /**
     * 单重(单位KG)
     */
    @Column(name = "product_single_weight")
    private Double productSingleWeight;

    /**
     * 层数
     */
    @Column(name = "product_layer_num")
    private Integer productLayerNum;

    /**
     * 是否防霉(is_open)
     */
    @Column(name = "product_mould")
    private String productMould;

    /**
     * 是否写码(is_open)
     */
    @Column(name = "product_coding")
    private String productCoding;

    /**
     * 体系认证(product_sys_certification)
     */
    @Column(name = "product_sys_certification")
    private String productSysCertification;

    /**
     * 仓库(store_name)
     */
    @Column(name = "store_name")
    private String storeName;

    /**
     * 采购单位(product_buy_unit)
     */
    @Column(name = "product_buy_unit")
    private String productBuyUnit;

    /**
     * 作业指导书id
     */
    @Column(name = "work_instruction_base_info_id")
    private String workInstructionBaseInfoId;

    private static final long serialVersionUID = 1L;
}