package com.huigou.topsun.proofing.domain.model.workInstruction;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 作业指导书排版参数
 * @TableName work_instruction_pd_published_conf
 */
@Table(name="work_instruction_pd_published_conf")
@Entity
@Data
public class WorkInstructionPdPublishedConf implements Serializable {
    /**
     * 作业指导书排版参数id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "work_instruction_pd_published_conf_id")
    private String workInstructionPdPublishedConfId;

    /**
     * 模数
     */
    private Integer modulus;

    /**
     * 行数
     */
    @Column(name = "row_num")
    private Integer rowNum;

    /**
     * 列数
     */
    @Column(name = "column_num")
    private Integer columnNum;

    /**
     * 搭版数
     */
    @Column(name = "contact_num")
    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */
    @Column(name = "row_double_blade")
    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */
    @Column(name = "column_double_blade")
    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */
    @Column(name = "dispatch_multiple")
    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */
    @Column(name = "sheet_length")
    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    @Column(name = "sheet_width")
    private Double sheetWidth;

    /**
     * 产品印张设置(product_sheet_conf)
     */
    @Column(name = "product_sheet_conf")
    private String productSheetConf;

    /**
     * 印刷正面颜色
     */
    @Column(name = "print_front_coler")
    private String printFrontColer;

    /**
     * 印刷反面颜色
     */
    @Column(name = "print_opposite_color")
    private String printOppositeColor;

    /**
     * 产品承印物
     */
    @Column(name = "product_substrate")
    private String productSubstrate;

    /**
     * 啤版编号
     */
    @Column(name = "beer_plate_no")
    private String beerPlateNo;

    /**
     * 烫金版编号
     */
    @Column(name = "gold_plate_no")
    private String goldPlateNo;

    /**
     * 模切版编号
     */
    @Column(name = "die_cut_plate_no")
    private String dieCutPlateNo;

    /**
     * 铜版及树脂版编号
     */
    @Column(name = "copperp_resin_late_no")
    private String copperpResinLateNo;

    /**
     * 网版编号
     */
    @Column(name = "net_plate_no")
    private String netPlateNo;

    /**
     * 工艺制程
     */
    @Column(name = "technology_process")
    private String technologyProcess;

    /**
     * 产品性质
     */
    @Column(name = "product_properties")
    private String productProperties;

    /**
     * 工艺要求
     */
    @Column(name = "technology_require")
    private String technologyRequire;

    /**
     * 包装方式
     */
    @Column(name = "package_style")
    private String packageStyle;

    /**
     * 物性测试
     */
    @Column(name = "physical_test")
    private String physicalTest;

    /**
     * 化性测试
     */
    @Column(name = "chemistry_test")
    private String chemistryTest;

    /**
     * 产品材质
     */
    @Column(name = "product_material")
    private String productMaterial;

    /**
     * 塑胶袋结构
     */
    @Column(name = "plastic_bag_structure")
    private String plasticBagStructure;

    /**
     * 铜版编号
     */
    @Column(name = "copperp_no")
    private String copperpNo;

    /**
     * 色号卡
     */
    @Column(name = "color_no_card")
    private String colorNoCard;

    /**
     * 模具编号
     */
    @Column(name = "plate_no")
    private String plateNo;

    /**
     * 表面处理
     */
    @Column(name = "surface_treatment")
    private String surfaceTreatment;

    /**
     * 产品描述
     */
    @Column(name = "product_describe")
    private String productDescribe;

    /**
     * 产品正面
     */
    @Column(name = "product_front")
    private String productFront;

    /**
     * 产品背面
     */
    @Column(name = "product_opposite")
    private String productOpposite;

    /**
     * 风险描述（序号、内容、等级）
     */
    @Column(name = "risk_description")
    private String riskDescription;

    /**
     * 是否附样图
     */
    @Column(name = "have_drawing")
    private String haveDrawing;

    /**
     * 是否要鞋图
     */
    @Column(name = "is_shoe_picture")
    private String isShoePicture;

    /**
     * 啤板模数
     */
    @Column(name = "beer_plate_num")
    private Integer beerPlateNum;

    /**
     * 模切板模数
     */
    @Column(name = "die_board_num")
    private Integer dieBoardNum;

    /**
     * 分切方向
     */
    @Column(name = "cut_direction")
    private String cutDirection;

    /**
     * 海关商品编码
     */
    @Column(name = "customs_commodity_code")
    private String customsCommodityCode;

    /**
     * 作业指导书id
     */
    @Column(name = "work_instruction_base_info_id")
    private String workInstructionBaseInfoId;

    private static final long serialVersionUID = 1L;
}