package com.huigou.topsun.proofing.domain.model.workInstruction;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 作业指导书物料信息
 * @TableName work_instruction_material_info
 */
@Table(name="work_instruction_material_info")
@Entity
@Data
public class WorkInstructionMaterialInfo implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "work_instruction_material_info_id")
    private String workInstructionMaterialInfoId;

    /**
     * bom单号
     */
    @Column(name = "bom_no")
    private String bomNo;

    /**
     * 版本号
     */
    @Column(name = "version_no")
    private String versionNo;

    /**
     * 数量
     */
    private Integer number;

    /**
     * 录入人id
     */
    @Column(name = "created_by_id")
    private String createdById;

    /**
     * 录入人名称
     */
    @Column(name = "created_by_name")
    private String createdByName;

    /**
     * 录入日期
     */
    @Column(name = "created_date")
    private Date createdDate;

    /**
     * 修改人id
     */
    @Column(name = "modified_by_id")
    private String modifiedById;

    /**
     * 修改人名称
     */
    @Column(name = "modified_by_name")
    private String modifiedByName;

    /**
     * 修改日期
     */
    @Column(name = "modified_date")
    private Date modifiedDate;

    /**
     * 状态（启用、禁用）
     */
    private Integer status;

    /**
     * 审核状态
     */
    @Column(name = "approval_status")
    private String approvalStatus;

    /**
     * 审核人
     */
    @Column(name = "approval_person")
    private String approvalPerson;

    /**
     * 审核日期
     */
    @Column(name = "approval_date")
    private Date approvalDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 印张长度(单位cm)
     */
    @Column(name = "material_sheet_length")
    private Double materialSheetLength;

    /**
     * 印张宽度(单位cm)
     */
    @Column(name = "material_sheet_width")
    private Double materialSheetWidth;

    /**
     * 满排个数
     */
    @Column(name = "full_number")
    private Integer fullNumber;

    /**
     * 损耗百分比(单位%)
     */
    @Column(name = "loss_rate")
    private Double lossRate;

    /**
     * 作业指导书id
     */
    @Column(name = "work_instruction_base_info_id")
    private String workInstructionBaseInfoId;

    private static final long serialVersionUID = 1L;
}