package com.huigou.topsun.proofing.domain.model.proofingMake;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样工艺
 * @TableName proofing_make_technology
 */
@Table(name="proofing_make_technology")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProofingMakeTechnology implements Serializable {
    /**
     * 打样工艺id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_apply_technology_id")
    private String proofingTechnologyId;

    /**
     * 工艺id
     */
    @Column(name = "technology_id")
    private String technologyId;

    /**
     * 工艺名称
     */
    @Column(name = "technology_name")
    private String technologyName;

    /**
     * 打样制作单id
     */
    @Column(name = "proofing_make_id")
    private String proofingMakeId;

    private static final long serialVersionUID = 1L;
}