package com.huigou.topsun.proofing.domain.model.proofingMake;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样制作单工序物料
 * @TableName proofing_make_process_material
 */
@Table(name="proofing_make_process_material")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProofingMakeProcessMaterial implements Serializable {
    /**
     * 打样制作工艺物料ID
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_make_process_material_id")
    private String proofingMakeProcessMaterialId;

    /**
     * 物料ID
     */
    @Column(name = "material_id")
    private String materialId;

    /**
     * 物料名称
     */
    @Column(name = "material_name")
    private String materialName;

    /**
     * 使用的物料数量
     */
    @Column(name = "material_number")
    private Double materialNumber;

    /**
     * 物料计量单位
     */
    @Column(name = "material_unit")
    private String materialUnit;

    /**
     * sap物料相信内容
     */
    @Column(name = "material_json")
    private String materialJson;

    /**
     * 工序ID
     */
    @Column(name = "proofing_make_process_id")
    private String proofingMakeProcessId;

    private static final long serialVersionUID = 1L;
}