package com.huigou.topsun.proofing.domain.model.proofingMake;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 样品外观要求
 * @TableName proofing_make_looked
 */
@Table(name="proofing_make_looked")
@Entity
@Data
public class ProofingMakeLooked implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_make_looked_id")
    private String proofingMakeLookedId;

    /**
     * 是否量产
     */
    @Column(name = "is_output")
    private String isOutput;

    /**
     * 是否外发
     */
    @Column(name = "is_out")
    private String isOut;

    /**
     * 是否改变
     */
    @Column(name = "is_change")
    private String isChange;

    /**
     * 塑胶袋结构
     */
    @Column(name = "plastic_bag_structure")
    private String plasticBagStructure;

    /**
     * 长;单位cm
     */
    @Column(name = "product_length")
    private Double productLength;

    /**
     * 宽;单位cm
     */
    @Column(name = "product_width")
    private Double productWidth;

    /**
     * 高;单位cm
     */
    @Column(name = "product_height")
    private Double productHeight;

    /**
     * 厚度;单位mm
     */
    @Column(name = "product_thick")
    private Double productThick;

    /**
     * 单层厚(单位丝)
     */
    @Column(name = "product_single_layer")
    private Integer productSingleLayer;

    /**
     * 层数
     */
    @Column(name = "product_layer_num")
    private Integer productLayerNum;

    /**
     * 样品形状
     */
    @Column(name = "sample_shape")
    private String sampleShape;

    /**
     * 样品形状大小
     */
    @Column(name = "sample_shape_size")
    private Double sampleShapeSize;

    /**
     * 预定工序流程id
     */
    @Column(name = "planned_flow_id")
    private String plannedFlowId;

    /**
     * 文件存储位置
     */
    @Column(name = "file_storage_location")
    private String fileStorageLocation;

    /**
     * 样品物料
     */
    @Column(name = "sample_material")
    private String sampleMaterial;

    /**
     * 成品克重;单位g
     */
    @Column(name = "product_weight")
    private Double productWeight;

    /**
     * 孔径(单位mm)
     */
    @Column(name = "product_aperture")
    private Double productAperture;

    /**
     * 单重(单位KG)
     */
    @Column(name = "product_single_weight")
    private Double productSingleWeight;

    /**
     * 样品制作单状态
     */
    @Column(name = "proofing_make_status")
    private String proofingMakeStatus;

    /**
     * 是否确认
     */
    @Column(name = "is_confirm")
    private String isConfirm;

    /**
     * 打样制作单id
     */
    @Column(name = "proofing_make_id")
    private String proofingMakeId;

    private static final long serialVersionUID = 1L;
}