package com.huigou.topsun.proofing.domain.model.proofingMake;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样制作单BOM
 * @TableName proofing_make_bom
 */
@Table(name="proofing_make_bom")
@Entity
@Data
public class ProofingMakeBom implements Serializable {
    /**
     * 打样制作单BOMid
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_make_bom_id")
    private String proofingMakeBomId;

    /**
     * 产品物料组成id
     */
    @Column(name = "product_material_id")
    private String productMaterialId;

    /**
     * 打样制作单id
     */
    @Column(name = "proofing_make_id")
    private String proofingMakeId;

    /**
     * 数量
     */
    @Column(name = "proofing_make_bom_num")
    private String proofingMakeBomNum;

    /**
     * 物料名称
     */
    @Column(name = "product_material_name")
    private String productMaterialName;

    private static final long serialVersionUID = 1L;
}