package com.huigou.topsun.proofing.domain.model.proofingApply;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样申请工艺
 * @TableName proofing_technology
 */
@Table(name="proofing_apply_technology")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class proofingApplyTechnology implements Serializable {
    /**
     * 打样工艺id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_apply_technology_id")
    private String proofingApplyTechnologyId;

    /**
     * 打样申请单id
     */
    @Column(name = "proofing_apply_id")
    private String proofingApplyId;

    /**
     * 工艺id
     */
    @Column(name = "technology_id")
    private String technologyId;

    /**
     * 工艺名称
     */
    @Column(name = "technology_name")
    private String technologyName;

    private static final long serialVersionUID = 1L;
}