package com.huigou.topsun.proofing.domain.model.proofingApply;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 
 * @TableName proofing_apply_process_material
 */
@Table(name="proofing_apply_process_material")
@Entity
@Data
public class ProofingApplyProcessMaterial implements Serializable {
    /**
     * 打样申请工艺物料ID
     */
    @Id
    @Column(name = "proofing_apply_process_material_id")
    private String proofingApplyProcessMaterialId;

    /**
     * 工序ID
     */
    @Column(name = "proofing_apply_process_id")
    private String proofingApplyProcessId;

    /**
     * 物料ID
     */
    @Column(name = "material_id")
    private String materialId;

    /**
     * 物料名称
     */
    @Column(name = "material_name")
    private String materialName;

    /**
     * 使用的物料数量
     */
    @Column(name = "material_number")
    private Double materialNumber;

    /**
     * 物料计量单位
     */
    @Column(name = "material_unit")
    private String materialUnit;

    /**
     * sap物料相信内容
     */
    @Column(name = "material_json")
    private String materialJson;

    private static final long serialVersionUID = 1L;
}