package com.huigou.topsun.proofing.domain.model.proofingApply;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样申请bom信息
 * @TableName proofing_apply_bom
 */
@Table(name="proofing_apply_bom")
@Entity
@Data
public class ProofingApplyBom implements Serializable {
    /**
     * 打样申请单BOMid
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_apply_bom_id")
    private String proofingApplyBomId;

    /**
     * 产品物料组成id
     */
    @Column(name = "product_material_id")
    private String productMaterialId;

    /**
     * 打样申请单id
     */
    @Column(name = "proofing_apply_id")
    private String proofingApplyId;

    /**
     * 数量
     */
    @Column(name = "proofing_apply_bom_num")
    private String proofingApplyBomNum;

    /**
     * 物料名称
     */
    @Column(name = "product_material_name")
    private String productMaterialName;

    private static final long serialVersionUID = 1L;
}