package com.huigou.topsun.proofing.domain.model.proofingApply;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 打样申请基本信息
 * @TableName proofing_apply_base_info
 */
@Table(name="proofing_apply_base_info")
@Entity
@Data
public class ProofingApplyBaseInfo extends FlowBillAbstractEntity {
    /**
     * 申请单id
     */
    @Column(name = "proofing_apply_id")
    private String proofingApplyId;

    /**
     * 申请单号
     */
    @Column(name = "proofing_apply_no")
    private String proofingApplyNo;

    /**
     * 产品id
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 品牌客户编号
     */
    @Column(name = "customer_code")
    private String customerCode;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 版面
     */
    private String page;

    /**
     * 版面需求时间
     */
    @Column(name = "proofing_apply_page_need_time")
    private Date proofingApplyPageNeedTime;

    /**
     * 完成日期
     */
    @Column(name = "proofing_apply_complete_date")
    private Date proofingApplyCompleteDate;

    /**
     * 样品中文名称
     */
    @Column(name = "proofing_apply_sample_cn_name")
    private String proofingApplySampleCnName;

    /**
     * 样品英文名称
     */
    @Column(name = "proofing_apply_sample_en_name")
    private String proofingApplySampleEnName;

    /**
     * 样品版次
     */
    @Column(name = "proofing_apply_sample_version")
    private Integer proofingApplySampleVersion;

    /**
     * 样品规格
     */
    @Column(name = "proofing_apply_sample_size")
    private Integer proofingApplySampleSize;

    /**
     * 样品数量
     */
    @Column(name = "proofing_apply_sample_num")
    private Long proofingApplySampleNum;

    /**
     * 产量情况
     */
    @Column(name = "proofing_apply_output_situation")
    private String proofingApplyOutputSituation;

    /**
     * 产品代号
     */
    @Column(name = "proofing_apply_product_no")
    private String proofingApplyProductNo;

    /**
     * 打样形式
     */
    @Column(name = "proofing_type")
    private String proofingType;

    /**
     * 分配方式
     */
    @Column(name = "proofing_apply_allocation_type")
    private String proofingApplyAllocationType;

    /**
     * 产品类别名称
     */
    @Column(name = "product_category_name")
    private String productCategoryName;

    /**
     * 表面处理
     */
    @Column(name = "proofing_apply_surface_treatment")
    private String proofingApplySurfaceTreatment;

    /**
     * NG重新打样原因
     */
    @Column(name = "proofing_apply_ng_re_reason")
    private String proofingApplyNgReReason;

    /**
     * 申请单状态
     */
    @Column(name = "proofing_apply_application_status")
    private String proofingApplyApplicationStatus;

    /**
     * 测试标准
     */
    @Column(name = "proofing_apply_test_standard")
    private String proofingApplyTestStandard;



    @Override
    protected String getCodeRuleId() {
        return "proofingApply";
    }
}