package com.huigou.topsun.proofing.domain.model;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 作业指导申请书
 * @TableName work_instruction_apply
 */
@Table(name="work_instruction_apply")
@Entity
@Data
public class WorkInstructionApply implements Serializable {
    /**
     * 作业指导申请书id
     */
    @Id
    @Column(name = "work_instruction_apply_id")
    private String workInstructionApplyId;

    /**
     * 打样制作单id
     */
    @Column(name = "proofing_make_id")
    private String proofingMakeId;

    /**
     * 规格书编号
     */
    @Column(name = "specification_no")
    private String specificationNo;

    /**
     * 换算值
     */
    @Column(name = "matrixing_value")
    private Integer matrixingValue;

    /**
     * 尺码组
     */
    @Column(name = "size_group")
    private String sizeGroup;

    /**
     * 是否禁用
     */
    @Column(name = "is_disable")
    private String isDisable;

    /**
     * 是否创建新规格书
     */
    @Column(name = "is_new_specification")
    private String isNewSpecification;

    /**
     * 是否要鞋图
     */
    @Column(name = "is_shoe_pattern")
    private String isShoePattern;

    /**
     * 是否附样品
     */
    @Column(name = "is_attached_sample")
    private String isAttachedSample;

    /**
     * 是否为唯一码产品
     */
    @Column(name = "is_only_code")
    private String isOnlyCode;

    /**
     * 是否不考虑形体配色
     */
    @Column(name = "is_body_color")
    private String isBodyColor;

    private static final long serialVersionUID = 1L;
}