package com.huigou.topsun.proofing.controller;

import com.huigou.topsun.proofing.application.WorkInstructionApplication;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;


@Controller
@ControllerMapping("/workInstruction")
public class WorkInstructionController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/proofing/";
    }

    @Autowired
    WorkInstructionApplication workInstructionApplication;


    /**
     * 跳转作业指导书
     * 如果有productId参数，就说明从打样制造单发送的请求，携带该参数跳转
     * @return
     */
    public String forwardWorkInstruction(){
        SDO sdo = this.getSDO();
        String workInstructionApplyId = sdo.getString("workInstructionApplyId");
        if(workInstructionApplyId!=null&&!"".equals(workInstructionApplyId)) this.putAttribute("workInstructionApplyId", workInstructionApplyId);
        return forward("workInstruction");
    }


    /**
     * 编辑作业指导书
     * @return
     */

    public String saveWorkInstruction(){
        SDO sdo = this.getSDO();
        String workInstructionId = workInstructionApplication.saveWorkInstruction(sdo);
        return success(workInstructionId);
    }

}

