package com.huigou.topsun.proofing.controller;

import com.huigou.topsun.product.application.ProductApplication;
import com.huigou.topsun.proofing.application.WorkInstructionApplyApplication;
import com.huigou.topsun.proofing.domain.model.WorkInstructionApply;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.UUID;


@Controller
@ControllerMapping("/workInstructionApply")
public class WorkInstructionApplyController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/proofing/";
    }

    @Autowired
    ProductApplication productApplication;
    @Autowired
    WorkInstructionApplyApplication workInstructionApplyApplication;


    /**
     * 跳转作业指导申请书
     * 如果有productId参数，就说明从打样制造单发送的请求，携带该参数跳转
     * @return
     */
    public String forwardWorkInstructionApply(){
        SDO sdo = this.getSDO();
        String productId = sdo.getString("productId");
        String workInstructionApplyId = UUID.randomUUID().toString().replace("-", "");
        this.putAttribute("workInstructionApplyId",workInstructionApplyId);
        if(productId!=null&&!"".equals(productId))this.putAttribute("productId", productId);
        return forward("workInstructionApply");
    }


    /**
     * 添加指导申请书
     */
    public String saveWorkInstructionApply(){
        SDO sdo = this.getSDO();
        WorkInstructionApply workInstructionApply = sdo.toObject(WorkInstructionApply.class);
        workInstructionApplyApplication.saveWorkInstructionApply(workInstructionApply);
        return toResult(workInstructionApply);
    }

}

