package com.huigou.topsun.proofing.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.product.application.ProductLookedApplication;
import com.huigou.topsun.product.domain.ProductLooked;
import com.huigou.topsun.proofing.application.ProofingApplyApplication;

import com.huigou.topsun.proofing.application.ProofingApplyLookedApplication;
import com.huigou.topsun.proofing.domain.model.proofingApply.ProofingApplyBaseInfo;
import com.huigou.topsun.proofing.domain.model.proofingApply.ProofingApplyLooked;
import com.huigou.topsun.proofing.domain.query.ProofingApplyQuery;
import com.huigou.topsun.technology.application.TechnologyApplication;
import com.huigou.topsun.technology.application.TechnologyProcessApplication;
import com.huigou.topsun.technology.domain.query.TechnologyQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.*;

@Controller
@ControllerMapping("/proofingApply")
public class ProofingApplyController extends CommonController {
    protected String getPagePath() {
        return "/biz/topsun/proofing/";
    }

    @Autowired
    ProofingApplyApplication proofingApplyApplication;
    @Autowired
    TechnologyApplication technologyApplication;
    @Autowired
    ProofingApplyLookedApplication proofingApplyLookedApplication;

    @Autowired
    ProductLookedApplication productLookedApplication;
    @Resource
    private TechnologyProcessApplication technologyProcessApplication;

    /**
     * 打样申请详情
     * @return
     */
        public String slicedProofingApplyList(){
            SDO sdo = this.getSDO();
            ProofingApplyQuery queryRequest = sdo.toQueryRequest(ProofingApplyQuery.class);
            Map<String, Object> map = proofingApplyApplication.slicedQuery(queryRequest);
            return toResult(map);
    }

    public String forwardProofingApplyList(){
        return forward("proofingApplyList");
    }


    /**
     * 打样表单页
     * @return
     */
    public String forwardProofingApply(){
        this.putAttribute("processDefinitionKey",ProofingApplyApplication.PROCESS_DEFINITION_KEY);
        this.putAttribute("procUnitId", "Apply");//定义流程环节的id
        ProofingApplyBaseInfo proofingApply = new ProofingApplyBaseInfo();
        proofingApply.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();//获取当前操作员的详情信息
        proofingApply.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        proofingApply.setProofingApplyNo(proofingApply.getBillCode()); //将生成的单号赋予实体类对应字段
        return forward("proofingApply",proofingApply);
    }

    /**
     * 工作流审核跳转页面
     * @return
     */
    public String showProofingApply() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        ProofingApplyBaseInfo proofingApply = proofingApplyApplication.loadProofingApplyById(id);
        return forward("proofingApply", proofingApply);
    }

    /**
     * 根据产品编号获取外观详情
     * @return
     */
    public String queryProductLooked(){
        SDO sdo = this.getSDO();
        String proofingApplyNo = sdo.getString("proofingApplyNo");
        String productId = sdo.getString("productId");
        if(proofingApplyNo!=null&&!"".equals(proofingApplyNo)){
            ProofingApplyBaseInfo proofingApplyBaseInfo = proofingApplyApplication.selectProofingApplyByProofingApplyNo(proofingApplyNo);
            ProofingApplyLooked proofingApplyLooked = proofingApplyLookedApplication.findByProofingApplyId(proofingApplyBaseInfo.getProofingApplyId());
            return toResult(proofingApplyLooked);
        }else if(productId!=null&&!"".equals(productId)){
            ProductLooked productLooked = new ProductLooked();
            productLooked.setProductId(productId);
            ProductLooked newProductLooked = productLookedApplication.getProductLookedByEntity(productLooked);
            return toResult(newProductLooked);
        }
        return toResult(null);
    }



    /**
     * 展示工艺
     * @return
     */
    public String slicedTechnologyList(){
        SDO sdo = this.getSDO();
        TechnologyQueryRequest queryRequest = sdo.toQueryRequest(TechnologyQueryRequest.class);
        Map<String, Object> map = technologyApplication.slicedTechnologyList(queryRequest);
        return toResult(map);
    }


    /**
     * 展示工序
     * @return
     */
    public String slicedTechnologyProcessList(){
        SDO sdo = this.getSDO();
        String technologyId = sdo.getString("technologyId");
        return packGridDataAndResult(technologyProcessApplication.slicedTechnologyProcessList(technologyId));
    }
}
