package com.huigou.topsun.proofing.application.impl;

import com.huigou.topsun.proofing.application.WorkInstructionApplication;
import com.huigou.topsun.proofing.domain.model.workInstruction.*;
import com.huigou.topsun.proofing.repository.*;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkInstructionApplicationImpl implements WorkInstructionApplication {

    @Autowired
    WorkInstructionRepository workInstructionRepository;
    @Autowired
    WorkInstructionPdPublishedConfRepository workInstructionPdPublishedConfRepository;
    @Autowired
    WorkInstructionMaterialInfoRepository workInstructionMaterialInfoRepository;
    @Autowired
    WorkInstructionOptionalAttributeRepository workInstructionOptionalAttributeRepository;
    @Autowired
    WorkInstructionPrdLookedRepository workInstructionPrdLookedRepository;
    @Autowired
    WorkInstructionProductLossRepository workInstructionProductLossRepository;

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public String saveWorkInstruction(SDO sdo) {
        WorkInstructionBaseInfo workInstruction = sdo.toObject(WorkInstructionBaseInfo.class);
        WorkInstructionPdPublishedConf workInstructionPdPublishedConf = sdo.toObject(WorkInstructionPdPublishedConf.class);
        WorkInstructionMaterialInfo workInstructionMaterialInfo = sdo.toObject(WorkInstructionMaterialInfo.class);
        WorkInstructionOptionalAttribute  workInstructionOptionalAttribute = sdo.toObject( WorkInstructionOptionalAttribute.class);
        WorkInstructionPrdLooked workInstructionPrdLooked = sdo.toObject(WorkInstructionPrdLooked.class);
        WorkInstructionProductLoss workInstructionProductLoss = sdo.toObject(WorkInstructionProductLoss.class);

        WorkInstructionBaseInfo workInstructionBaseInfo = workInstructionRepository.save(workInstruction);

        workInstructionPdPublishedConf.setWorkInstructionBaseInfoId(workInstructionBaseInfo.getWorkInstructionBaseInfoId());
        workInstructionPdPublishedConfRepository.save(workInstructionPdPublishedConf);

        workInstructionMaterialInfo.setWorkInstructionBaseInfoId(workInstructionBaseInfo.getWorkInstructionBaseInfoId());
        workInstructionMaterialInfoRepository.save(workInstructionMaterialInfo);

        workInstructionOptionalAttribute.setWorkInstructionBaseInfoId(workInstructionBaseInfo.getWorkInstructionBaseInfoId());
        workInstructionOptionalAttributeRepository.save(workInstructionOptionalAttribute);

        workInstructionPrdLooked.setWorkInstructionBaseInfoId(workInstructionBaseInfo.getWorkInstructionBaseInfoId());
        workInstructionPrdLookedRepository.save(workInstructionPrdLooked);

        workInstructionProductLoss.setWorkInstructionBaseInfoId(workInstructionBaseInfo.getWorkInstructionBaseInfoId());
        workInstructionProductLossRepository.save(workInstructionProductLoss);

        return workInstructionBaseInfo.getWorkInstructionBaseInfoId();
    }
}
