package com.huigou.topsun.proofing.application.impl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.proofing.application.ProofingMakeApplication;

import com.huigou.topsun.proofing.domain.model.proofingApply.ProofingApplyBaseInfo;
import com.huigou.topsun.proofing.domain.model.proofingApply.ProofingApplyProcess;
import com.huigou.topsun.proofing.domain.model.proofingApply.proofingApplyTechnology;
import com.huigou.topsun.proofing.domain.model.proofingMake.*;
import com.huigou.topsun.proofing.domain.query.ProofingMakeQueryRequest;
import com.huigou.topsun.proofing.domain.vo.ProofingMakeVo;
import com.huigou.topsun.proofing.repository.*;

import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import lombok.SneakyThrows;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;


/**
* @author 16508
* @description 针对表【technology(工艺)】的数据库操作Service实现
* @createDate 2023-11-22 11:04:03
*/
@Service
public class ProofingMakeApplicationImpl extends BaseApplication implements ProofingMakeApplication {

    @Autowired
    ProofingMakeRepository proofingMakeRepository;
    @Autowired
    ProofingApplyRepository proofingApplyRepository;
    @Autowired
    ProofingMakeLookedRepository proofingMakeLookedRepository;
    @Autowired
    ProofingMakePdPublishedConfRepository proofingMakePdPublishedConfRepository;
    @Autowired
    ProofingMakeTechnologyRepository proofingMakeTechnologyRepository;
    @Autowired
    ProofingMakeProcessRepository proofingMakeProcessRepository;
    @Autowired
    ProofingMakeProcessMaterialRepository proofingMakeProcessMaterialRepository;


    @Override
    public Map<String, Object> slicedProofingMakeQuery(ProofingMakeQueryRequest query) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedProofingMakeList");
        return this.sqlExecutorDao.executeSlicedQuery(queryDescriptor,query);
    }

    /**
     * 编辑打样制造及相关信息
     * @param sdo 打样制造及相关信息
     */
    @SneakyThrows
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    public void saveProofingMake(SDO sdo) {
        ProofingMakeBaseInfo proofingMakeBaseInfo = sdo.toObject(ProofingMakeBaseInfo.class);
        ProofingMakeLooked proofingMakeLooked = sdo.toObject(ProofingMakeLooked.class);
        ProofingMakePdPublishedConf proofingMakePdPublishedConf = sdo.toObject(ProofingMakePdPublishedConf.class);

        proofingMakeBaseInfo.setProofingMakeApplicationStatus(StringUtil.isBlank(proofingMakeBaseInfo.getProofingMakeNgReReason())?"normal":"cancel");
        proofingMakeBaseInfo = proofingMakeRepository.save(proofingMakeBaseInfo);

        proofingMakeLooked.setProofingMakeId(proofingMakeBaseInfo.getProofingMakeId());
        proofingMakeLookedRepository.save(proofingMakeLooked);

        proofingMakePdPublishedConf.setProofingMakeId(proofingMakeBaseInfo.getProofingMakeId());
        proofingMakePdPublishedConfRepository.save(proofingMakePdPublishedConf);

        String technologyJSON = sdo.getString("technology");
        String processJSON = sdo.getString("process");
        ObjectMapper objectMapper = new ObjectMapper();
        ProofingMakeTechnology proofingMakeTechnology = objectMapper.readValue(technologyJSON, ProofingMakeTechnology.class);
        List<ProofingMakeProcess> ProcessList = objectMapper.readValue(processJSON, new TypeReference<List<ProofingMakeProcess>>() {});

        proofingMakeTechnology.setProofingMakeId(proofingMakeBaseInfo.getProofingMakeId());
        proofingMakeTechnology = proofingMakeTechnologyRepository.save(proofingMakeTechnology);

        for (ProofingMakeProcess proofingMakeProcess : ProcessList) {
            proofingMakeProcess.setProofingMakeTechnologyId(proofingMakeTechnology.getProofingTechnologyId());
            proofingMakeProcessRepository.save(proofingMakeProcess);
        }
    }

    @Override
    public ProofingMakeVo getProofingMakeVoById(String proofingMakeId) {
        ProofingMakeVo proofingMakeVo = new ProofingMakeVo();
        ProofingMakeBaseInfo proofingMake = proofingMakeRepository.findOne(proofingMakeId);
        ProofingApplyBaseInfo proofingApply = proofingApplyRepository.findByProofingApplyId(proofingMake.getProofingApplyId());
        BeanUtils.copyProperties(proofingMake,proofingMakeVo);
        BeanUtils.copyProperties(proofingApply,proofingMakeVo);
        return proofingMakeVo;
    }
}



