package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 尺码组主表
 *
 * @TableName size_group
 */
@Table(name = "size_group")
@Data
@Entity
public class SizeGroup implements Serializable {
    /**
     * 尺码组id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "size_group_id")
    private String sizeGroupId;

    /**
     * 尺码组名称
     */
    @Column(name = "size_group_name")
    private String sizeGroupName;

    /**
     * 尺码组编码
     */
    @Column(name = "size_group_code")
    private String sizeGroupCode;

    /**
     * 尺码组类型
     */
    @Column(name = "size_group_type")
    private String sizeGroupType;

    /**
     * 录入人
     */
    @Column(name = "created_by_name")
    private String createdByName;

    /**
     * 录入人id
     */
    @Column(name = "created_by_id")
    private String createdById;

    /**
     * 录入时间
     */
    @Column(name = "created_date")
    private Date createdDate;

    /**
     * 修改人id
     */
    @Column(name = "last_modified_by_id")
    private String lastModifiedById;

    /**
     * 修改人
     */
    @Column(name = "last_modified_by_name")
    private String lastModifiedByName;

    /**
     * 修改日期
     */
    @Column(name = "last_modified_date")
    private Date lastModifiedDate;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SizeGroup other = (SizeGroup) o;
        return (this.getSizeGroupId() == null ? other.getSizeGroupId() == null : this.getSizeGroupId().equals(other.getSizeGroupId()))
                && (this.getSizeGroupName() == null ? other.getSizeGroupName() == null : this.getSizeGroupName().equals(other.getSizeGroupName()))
                && (this.getSizeGroupCode() == null ? other.getSizeGroupCode() == null : this.getSizeGroupCode().equals(other.getSizeGroupCode()))
                && (this.getSizeGroupType() == null ? other.getSizeGroupType() == null : this.getSizeGroupType().equals(other.getSizeGroupType()))
                && (this.getCreatedDate() == null ? other.getCreatedDate() == null : this.getCreatedDate().equals(other.getCreatedDate()))
                && (this.getCreatedByName() == null ? other.getCreatedByName() == null : this.getCreatedByName().equals(other.getCreatedByName()))
                && (this.getCreatedById() == null ? other.getCreatedById() == null : this.getCreatedById().equals(other.getCreatedById()))
                && (this.getLastModifiedDate() == null ? other.getLastModifiedDate() == null : this.getLastModifiedDate().equals(other.getLastModifiedDate()))
                && (this.getLastModifiedById() == null ? other.getLastModifiedById() == null : this.getLastModifiedById().equals(other.getLastModifiedById()))
                && (this.getLastModifiedByName() == null ? other.getLastModifiedByName() == null : this.getLastModifiedByName().equals(other.getLastModifiedByName()));
    }

    @Override
    public int hashCode() {

        final int prime = 1;
        int result = 1;
        result = prime * result + ((getSizeGroupId() == null) ? 0 : getSizeGroupId().hashCode());
        result = prime * result + ((getSizeGroupCode() == null) ? 0 : getSizeGroupCode().hashCode());
        result = prime * result + ((getSizeGroupName() == null) ? 0 : getSizeGroupName().hashCode());
        result = prime * result + ((getSizeGroupType() == null) ? 0 : getSizeGroupType().hashCode());
        result = prime * result + ((getCreatedDate() == null) ? 0 : getCreatedDate().hashCode());
        result = prime * result + ((getCreatedById() == null) ? 0 : getCreatedById().hashCode());
        result = prime * result + ((getCreatedByName() == null) ? 0 : getCreatedByName().hashCode());
        result = prime * result + ((getLastModifiedDate() == null) ? 0 : getLastModifiedDate().hashCode());
        result = prime * result + ((getLastModifiedById() == null) ? 0 : getLastModifiedById().hashCode());
        result = prime * result + ((getLastModifiedByName() == null) ? 0 : getLastModifiedByName().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(getClass().getSimpleName());
        stringBuilder.append(" [");
        stringBuilder.append("Hash = ").append(hashCode());
        stringBuilder.append("sizeGroupId=").append(sizeGroupId);
        stringBuilder.append(", sizeGroupName=").append(sizeGroupName);
        stringBuilder.append(", sizeGroupCode=").append(sizeGroupCode);
        stringBuilder.append(", sizeGroupType=").append(sizeGroupType);
        stringBuilder.append(", createdByName=").append(createdByName);
        stringBuilder.append(", createdById=").append(createdById);
        stringBuilder.append(", createdDate=").append(createdDate);
        stringBuilder.append(", lastModifiedById=").append(lastModifiedById);
        stringBuilder.append(", lastModifiedByName=").append(lastModifiedByName);
        stringBuilder.append(", lastModifiedDate=").append(lastModifiedDate);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}