package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 产品排版配置ID
 * @TableName product_typeset_conf
 */
@Table(name="product_typeset_conf")
@Data
@Entity
public class ProductTypesetConf implements Serializable {
    /**
     * 产品排版配置ID
     */
    @Id
    @Column(name = "product_typeset_conf_id")
    private String productTypesetConfId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 印张长度(单位cm)
     */
    private Double length;

    /**
     * 印张宽度(单位cm)
     */
    private Double width;

    /**
     * 满排个数
     */
    private Integer number;

    /**
     * 损耗百分比(单位%)
     */
    @Column(name = "loss_rate")
    private Double lossRate;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProductTypesetConf other = (ProductTypesetConf) that;
        return (this.getProductTypesetConfId() == null ? other.getProductTypesetConfId() == null : this.getProductTypesetConfId().equals(other.getProductTypesetConfId()))
            && (this.getProductId() == null ? other.getProductId() == null : this.getProductId().equals(other.getProductId()))
            && (this.getLength() == null ? other.getLength() == null : this.getLength().equals(other.getLength()))
            && (this.getWidth() == null ? other.getWidth() == null : this.getWidth().equals(other.getWidth()))
            && (this.getNumber() == null ? other.getNumber() == null : this.getNumber().equals(other.getNumber()))
            && (this.getLossRate() == null ? other.getLossRate() == null : this.getLossRate().equals(other.getLossRate()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProductTypesetConfId() == null) ? 0 : getProductTypesetConfId().hashCode());
        result = prime * result + ((getProductId() == null) ? 0 : getProductId().hashCode());
        result = prime * result + ((getLength() == null) ? 0 : getLength().hashCode());
        result = prime * result + ((getWidth() == null) ? 0 : getWidth().hashCode());
        result = prime * result + ((getNumber() == null) ? 0 : getNumber().hashCode());
        result = prime * result + ((getLossRate() == null) ? 0 : getLossRate().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", productTypesetConfId=").append(productTypesetConfId);
        sb.append(", productId=").append(productId);
        sb.append(", length=").append(length);
        sb.append(", width=").append(width);
        sb.append(", number=").append(number);
        sb.append(", lossRate=").append(lossRate);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}