package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 产品打样排版参数配置
 * @TableName product_published_conf
 */
@Table(name="product_published_conf")
@Data
@Entity
public class ProductPublishedConf implements Serializable {
    /**
     * 排版参数配置ID
     */
    @Id
    @Column(name = "product_published_conf_id")
    private String productPublishedConfId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 模数
     */
    @Column(name = "modulus")
    private Integer modulus;

    /**
     * 行数
     */
    @Column(name = "row_num")
    private Integer rowNum;

    /**
     * 列数
     */
    @Column(name = "column_num")
    private Integer columnNum;

    /**
     * 搭版数
     */
    @Column(name = "contact_num")
    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */
    @Column(name = "row_double_blade")
    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */
    @Column(name = "column_double_blade")
    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */
    @Column(name = "dispatch_multiple")
    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */
    @Column(name = "sheet_length")
    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    @Column(name = "sheet_width")
    private Double sheetWidth;

    /**
     * 产品印张设置(product_sheet_conf)
     */
    @Column(name = "product_sheet_conf")
    private String productSheetConf;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProductPublishedConf other = (ProductPublishedConf) that;
        return (this.getProductPublishedConfId() == null ? other.getProductPublishedConfId() == null : this.getProductPublishedConfId().equals(other.getProductPublishedConfId()))
            && (this.getProductId() == null ? other.getProductId() == null : this.getProductId().equals(other.getProductId()))
            && (this.getModulus() == null ? other.getModulus() == null : this.getModulus().equals(other.getModulus()))
            && (this.getRowNum() == null ? other.getRowNum() == null : this.getRowNum().equals(other.getRowNum()))
            && (this.getColumnNum() == null ? other.getColumnNum() == null : this.getColumnNum().equals(other.getColumnNum()))
            && (this.getContactNum() == null ? other.getContactNum() == null : this.getContactNum().equals(other.getContactNum()))
            && (this.getRowDoubleBlade() == null ? other.getRowDoubleBlade() == null : this.getRowDoubleBlade().equals(other.getRowDoubleBlade()))
            && (this.getColumnDoubleBlade() == null ? other.getColumnDoubleBlade() == null : this.getColumnDoubleBlade().equals(other.getColumnDoubleBlade()))
            && (this.getDispatchMultiple() == null ? other.getDispatchMultiple() == null : this.getDispatchMultiple().equals(other.getDispatchMultiple()))
            && (this.getSheetLength() == null ? other.getSheetLength() == null : this.getSheetLength().equals(other.getSheetLength()))
            && (this.getSheetWidth() == null ? other.getSheetWidth() == null : this.getSheetWidth().equals(other.getSheetWidth()))
            && (this.getProductSheetConf() == null ? other.getProductSheetConf() == null : this.getProductSheetConf().equals(other.getProductSheetConf()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProductPublishedConfId() == null) ? 0 : getProductPublishedConfId().hashCode());
        result = prime * result + ((getProductId() == null) ? 0 : getProductId().hashCode());
        result = prime * result + ((getModulus() == null) ? 0 : getModulus().hashCode());
        result = prime * result + ((getRowNum() == null) ? 0 : getRowNum().hashCode());
        result = prime * result + ((getColumnNum() == null) ? 0 : getColumnNum().hashCode());
        result = prime * result + ((getContactNum() == null) ? 0 : getContactNum().hashCode());
        result = prime * result + ((getRowDoubleBlade() == null) ? 0 : getRowDoubleBlade().hashCode());
        result = prime * result + ((getColumnDoubleBlade() == null) ? 0 : getColumnDoubleBlade().hashCode());
        result = prime * result + ((getDispatchMultiple() == null) ? 0 : getDispatchMultiple().hashCode());
        result = prime * result + ((getSheetLength() == null) ? 0 : getSheetLength().hashCode());
        result = prime * result + ((getSheetWidth() == null) ? 0 : getSheetWidth().hashCode());
        result = prime * result + ((getProductSheetConf() == null) ? 0 : getProductSheetConf().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", productPublishedConfId=").append(productPublishedConfId);
        sb.append(", productId=").append(productId);
        sb.append(", modulus=").append(modulus);
        sb.append(", rowNum=").append(rowNum);
        sb.append(", columnNum=").append(columnNum);
        sb.append(", contactNum=").append(contactNum);
        sb.append(", rowDoubleBlade=").append(rowDoubleBlade);
        sb.append(", columnDoubleBlade=").append(columnDoubleBlade);
        sb.append(", dispatchMultiple=").append(dispatchMultiple);
        sb.append(", sheetLength=").append(sheetLength);
        sb.append(", sheetWidth=").append(sheetWidth);
        sb.append(", productSheetConf=").append(productSheetConf);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}