package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.util.Objects;

import javax.persistence.*;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * @author Tison
 * 产品工艺工序
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Entity
@Table(name = "product_process")
public class ProductProcess implements Serializable {

	/**
	 * 产品工艺工序id
	 */
	@Id
	@Column(name = "product_process_id", nullable = false, length = 32)
	private String productProcessId;

	/**
	 * 工艺id
	 */
	@Column(name = "product_technology_id", nullable = true, length = 32)
	private String productTechnologyId;

	/**
	 * 生成顺序
	 */
	@Column(name = "production_sequence", nullable = true)
	private Integer productionSequence;

	/**
	 * 工序名称
	 */
	@Column(name = "process_name", nullable = true, length = 32)
	private String processName;

	/**
	 * 是否排期工序
	 */
	@Column(name = "is_schedule_process", nullable = true, length = 10)
	private String isScheduleProcess;

	/**
	 * 是否完成工序
	 */
	@Column(name = "is_finished_process", nullable = true, length = 10)
	private String isFinishedProcess;

	/**
	 * 工艺备注
	 */
	@Column(name = "process_remark", nullable = true, length = 255)
	private String processRemark;

	/**
	 * 完成时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@Column(name = "finished_time", nullable = true)
	private java.util.Date finishedTime;

	/**
	 * 签字
	 */
	@Column(name = "signed", nullable = true, length = 255)
	private String signed;

	@Override
	public boolean equals(Object o) {
		if (this == o) { return true; }
		if (o == null || getClass() != o.getClass()) { return false; }
		ProductProcess that = (ProductProcess) o;
		return Objects.equals(productProcessId, that.productProcessId) && Objects.equals(productTechnologyId, that.productTechnologyId) && Objects.equals(productionSequence, that.productionSequence) && Objects.equals(processName, that.processName) && Objects.equals(isScheduleProcess, that.isScheduleProcess) && Objects.equals(isFinishedProcess, that.isFinishedProcess) && Objects.equals(processRemark, that.processRemark) && Objects.equals(finishedTime, that.finishedTime) && Objects.equals(signed, that.signed);
	}

	@Override
	public int hashCode() {
		return Objects.hash(productProcessId, productTechnologyId, productionSequence, processName, isScheduleProcess, isFinishedProcess, processRemark, finishedTime, signed);
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
				.toString();
	}

	public String getProductProcessId() {
		return this.productProcessId;
	}
	
	public void setProductProcessId(String productProcessId) {
		this.productProcessId = productProcessId;
	}
	
	public String getProductTechnologyId() {
		return this.productTechnologyId;
	}
	
	public void setProductTechnologyId(String productTechnologyId) {
		this.productTechnologyId = productTechnologyId;
	}
	
	public Integer getProductionSequence() {
		return this.productionSequence;
	}
	
	public void setProductionSequence(Integer productionSequence) {
		this.productionSequence = productionSequence;
	}
	
	public String getProcessName() {
		return this.processName;
	}
	
	public void setProcessName(String processName) {
		this.processName = processName;
	}
	
	public String getIsScheduleProcess() {
		return this.isScheduleProcess;
	}
	
	public void setIsScheduleProcess(String isScheduleProcess) {
		this.isScheduleProcess = isScheduleProcess;
	}
	
	public String getIsFinishedProcess() {
		return this.isFinishedProcess;
	}
	
	public void setIsFinishedProcess(String isFinishedProcess) {
		this.isFinishedProcess = isFinishedProcess;
	}
	
	public String getProcessRemark() {
		return this.processRemark;
	}
	
	public void setProcessRemark(String processRemark) {
		this.processRemark = processRemark;
	}
	
	public java.util.Date getFinishedTime() {
		return this.finishedTime;
	}
	
	public void setFinishedTime(java.util.Date finishedTime) {
		this.finishedTime = finishedTime;
	}
	
	public String getSigned() {
		return this.signed;
	}
	
	public void setSigned(String signed) {
		this.signed = signed;
	}
}
