package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 产品物料组成
 * @TableName product_material
 */
@Table(name="product_material")
@Data
@Entity
public class ProductMaterial implements Serializable {
    /**
     * 产品物料组成ID
     */
    @Id
    @Column(name = "product_material_id")
    private String productMaterialId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 物料ID
     */
    @Column(name = "material_id")
    private String materialId;

    /**
     * 物料数量
     */
    @Column(name = "material_number")
    private Integer materialNumber;

    /**
     * BOM版本
     */
    @Column(name = "bom_version")
    private String bomVersion;

    /**
     * 产品BOM类型(bom_type)
     */
    @Column(name = "bom_type")
    private String bomType;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProductMaterial other = (ProductMaterial) that;
        return (this.getProductMaterialId() == null ? other.getProductMaterialId() == null : this.getProductMaterialId().equals(other.getProductMaterialId()))
            && (this.getProductId() == null ? other.getProductId() == null : this.getProductId().equals(other.getProductId()))
            && (this.getMaterialId() == null ? other.getMaterialId() == null : this.getMaterialId().equals(other.getMaterialId()))
            && (this.getMaterialNumber() == null ? other.getMaterialNumber() == null : this.getMaterialNumber().equals(other.getMaterialNumber()))
            && (this.getBomVersion() == null ? other.getBomVersion() == null : this.getBomVersion().equals(other.getBomVersion()))
            && (this.getBomType() == null ? other.getBomType() == null : this.getBomType().equals(other.getBomType()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProductMaterialId() == null) ? 0 : getProductMaterialId().hashCode());
        result = prime * result + ((getProductId() == null) ? 0 : getProductId().hashCode());
        result = prime * result + ((getMaterialId() == null) ? 0 : getMaterialId().hashCode());
        result = prime * result + ((getMaterialNumber() == null) ? 0 : getMaterialNumber().hashCode());
        result = prime * result + ((getBomVersion() == null) ? 0 : getBomVersion().hashCode());
        result = prime * result + ((getBomType() == null) ? 0 : getBomType().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", productMaterialId=").append(productMaterialId);
        sb.append(", productId=").append(productId);
        sb.append(", materialId=").append(materialId);
        sb.append(", materialNumber=").append(materialNumber);
        sb.append(", bomVersion=").append(bomVersion);
        sb.append(", bomType=").append(bomType);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}