package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 产品loss配置
 * @TableName product_loss
 */
@Table(name="product_loss")
@Data
@Entity
public class ProductLoss implements Serializable {
    /**
     * 产品lossID
     */
    @Id
    @Column(name = "product_loss_id")
    private String productLossId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 产品最大loss数量
     */
    @Column(name = "product_loss_max")
    private Integer productLossMax;

    /**
     * loss比率(单位%)
     */
    @Column(name = "product_loss_rate")
    private Double productLossRate;

    /**
     * 冗余量
     */
    @Column(name = "product_loss_redundance")
    private Double productLossRedundance;

    /**
     * 备注信息
     */
    @Column(name = "product_loss_remark")
    private String productLossRemark;

    /**
     * 客户名称
     */
    @Column(name = "customer_name")
    private String customerName;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProductLoss other = (ProductLoss) that;
        return (this.getProductLossId() == null ? other.getProductLossId() == null : this.getProductLossId().equals(other.getProductLossId()))
            && (this.getProductId() == null ? other.getProductId() == null : this.getProductId().equals(other.getProductId()))
            && (this.getProductLossMax() == null ? other.getProductLossMax() == null : this.getProductLossMax().equals(other.getProductLossMax()))
            && (this.getProductLossRate() == null ? other.getProductLossRate() == null : this.getProductLossRate().equals(other.getProductLossRate()))
            && (this.getProductLossRedundance() == null ? other.getProductLossRedundance() == null : this.getProductLossRedundance().equals(other.getProductLossRedundance()))
            && (this.getProductLossRemark() == null ? other.getProductLossRemark() == null : this.getProductLossRemark().equals(other.getProductLossRemark()))
            && (this.getCustomerName() == null ? other.getCustomerName() == null : this.getCustomerName().equals(other.getCustomerName()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProductLossId() == null) ? 0 : getProductLossId().hashCode());
        result = prime * result + ((getProductId() == null) ? 0 : getProductId().hashCode());
        result = prime * result + ((getProductLossMax() == null) ? 0 : getProductLossMax().hashCode());
        result = prime * result + ((getProductLossRate() == null) ? 0 : getProductLossRate().hashCode());
        result = prime * result + ((getProductLossRedundance() == null) ? 0 : getProductLossRedundance().hashCode());
        result = prime * result + ((getProductLossRemark() == null) ? 0 : getProductLossRemark().hashCode());
        result = prime * result + ((getCustomerName() == null) ? 0 : getCustomerName().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", productLossId=").append(productLossId);
        sb.append(", productId=").append(productId);
        sb.append(", productLossMax=").append(productLossMax);
        sb.append(", productLossRate=").append(productLossRate);
        sb.append(", productLossRedundance=").append(productLossRedundance);
        sb.append(", productLossRemark=").append(productLossRemark);
        sb.append(", customerName=").append(customerName);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}