package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 产品版面颜色
 * @TableName product_face_color
 */
@Table(name="product_face_color")
@Data
@Entity
public class ProductFaceColor implements Serializable {
    /**
     * 产品颜色ID
     */
    @Id
    @Column(name = "product_face_color_id")
    private String productFaceColorId;

    /**
     * 产品版面ID
     */
    @Column(name = "product_face_id")
    private String productFaceId;

    /**
     * 颜色ID
     */
    @Column(name = "color_id")
    private String colorId;

    /**
     * 覆盖率(单位%)
     */
    @Column(name = "coverage_rate")
    private Double coverageRate;

    /**
     * 排序序号
     */
    @Column(name = "sort_order")
    private Integer sortOrder;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProductFaceColor other = (ProductFaceColor) that;
        return (this.getProductFaceColorId() == null ? other.getProductFaceColorId() == null : this.getProductFaceColorId().equals(other.getProductFaceColorId()))
            && (this.getProductFaceId() == null ? other.getProductFaceId() == null : this.getProductFaceId().equals(other.getProductFaceId()))
            && (this.getColorId() == null ? other.getColorId() == null : this.getColorId().equals(other.getColorId()))
            && (this.getCoverageRate() == null ? other.getCoverageRate() == null : this.getCoverageRate().equals(other.getCoverageRate()))
            && (this.getSortOrder() == null ? other.getSortOrder() == null : this.getSortOrder().equals(other.getSortOrder()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProductFaceColorId() == null) ? 0 : getProductFaceColorId().hashCode());
        result = prime * result + ((getProductFaceId() == null) ? 0 : getProductFaceId().hashCode());
        result = prime * result + ((getColorId() == null) ? 0 : getColorId().hashCode());
        result = prime * result + ((getCoverageRate() == null) ? 0 : getCoverageRate().hashCode());
        result = prime * result + ((getSortOrder() == null) ? 0 : getSortOrder().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", productFaceColorId=").append(productFaceColorId);
        sb.append(", productFaceId=").append(productFaceId);
        sb.append(", colorId=").append(colorId);
        sb.append(", coverageRate=").append(coverageRate);
        sb.append(", sortOrder=").append(sortOrder);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}