package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 产品版面信息
 * @TableName product_face
 */
@Table(name="product_face")
@Data
@Entity
public class ProductFace implements Serializable {
    /**
     * 产品版面ID
     */
    @Id
    @Column(name = "product_face_id")
    private String productFaceId;

    /**
     * 产品版面图片
     */
    @Column(name = "product_image")
    private String productImage;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProductFace other = (ProductFace) that;
        return (this.getProductFaceId() == null ? other.getProductFaceId() == null : this.getProductFaceId().equals(other.getProductFaceId()))
            && (this.getProductImage() == null ? other.getProductImage() == null : this.getProductImage().equals(other.getProductImage()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProductFaceId() == null) ? 0 : getProductFaceId().hashCode());
        result = prime * result + ((getProductImage() == null) ? 0 : getProductImage().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", productFaceId=").append(productFaceId);
        sb.append(", productImage=").append(productImage);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}