package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.util.Objects;

import javax.persistence.*;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * @author Tison
 * 产品详细信息
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Entity
@Table(name = "product_detail")
public class ProductDetail implements Serializable {

	/**
	 * 产品详细信息ID
	 */
	@Id
	@Column(name = "product_detail_id", nullable = false, length = 32)
	private String productDetailId;

	/**
	 * 产品ID
	 */
	@Column(name = "product_id", nullable = true, length = 32)
	private String productId;

	/**
	 * 工厂名称
	 */
	@Column(name = "factory_name", nullable = true, length = 255)
	private String factoryName;

	/**
	 * 版面(product_layout)
	 */
	@Column(name = "product_layout", nullable = true, length = 32)
	private String productLayout;

	/**
	 * 英文名
	 */
	@Column(name = "product_english_name", nullable = true, length = 255)
	private String productEnglishName;

	/**
	 * 产品简称
	 */
	@Column(name = "product_short_name", nullable = true, length = 128)
	private String productShortName;

	/**
	 * 产品背面ID
	 */
	@Column(name = "back_product_face_id", nullable = true, length = 32)
	private String backProductFaceId;

	/**
	 * 产品正面ID
	 */
	@Column(name = "right_product_face_id", nullable = true, length = 32)
	private String rightProductFaceId;

	/**
	 * 产品承印物
	 */
	@Column(name = "product_substrate", nullable = true, length = 255)
	private String productSubstrate;

	/**
	 * 材料代号
	 */
	@Column(name = "material_code", nullable = true, length = 255)
	private String materialCode;

	/**
	 * 产品代号
	 */
	@Column(name = "product_code", nullable = true, length = 255)
	private String productCode;

	/**
	 * 英文代号
	 */
	@Column(name = "product_en_code", nullable = true, length = 255)
	private String productEnCode;

	/**
	 * 型体配色
	 */
	@Column(name = "body_color", nullable = true, length = 255)
	private String bodyColor;

	/**
	 * 客户料号
	 */
	@Column(name = "customer_material_code", nullable = true, length = 255)
	private String customerMaterialCode;

	/**
	 * 版本号
	 */
	@Column(name = "version_no", nullable = true, length = 255)
	private String versionNo;

	/**
	 * 是否创建新规格书
	 */
	@Column(name = "is_new_specification", nullable = true, length = 1)
	private String isNewSpecification;

	/**
	 * 规格书编号
	 */
	@Column(name = "specification_no", nullable = true, length = 32)
	private String specificationNo;

	@Override
	public boolean equals(Object o) {
		if (this == o) { return true; }
		if (o == null || getClass() != o.getClass()) { return false; }
		ProductDetail that = (ProductDetail) o;
		return Objects.equals(productDetailId, that.productDetailId) && Objects.equals(productId, that.productId) && Objects.equals(factoryName, that.factoryName) && Objects.equals(productLayout, that.productLayout) && Objects.equals(productEnglishName, that.productEnglishName) && Objects.equals(productShortName, that.productShortName) && Objects.equals(backProductFaceId, that.backProductFaceId) && Objects.equals(rightProductFaceId, that.rightProductFaceId) && Objects.equals(productSubstrate, that.productSubstrate) && Objects.equals(materialCode, that.materialCode) && Objects.equals(productCode, that.productCode) && Objects.equals(productEnCode, that.productEnCode) && Objects.equals(bodyColor, that.bodyColor) && Objects.equals(customerMaterialCode, that.customerMaterialCode) && Objects.equals(versionNo, that.versionNo) && Objects.equals(isNewSpecification, that.isNewSpecification) && Objects.equals(specificationNo, that.specificationNo);
	}

	@Override
	public int hashCode() {
		return Objects.hash(productDetailId, productId, factoryName, productLayout, productEnglishName, productShortName, backProductFaceId, rightProductFaceId, productSubstrate, materialCode, productCode, productEnCode, bodyColor, customerMaterialCode, versionNo, isNewSpecification, specificationNo);
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
				.toString();
	}

	public String getProductDetailId() {
		return this.productDetailId;
	}
	
	public void setProductDetailId(String productDetailId) {
		this.productDetailId = productDetailId;
	}
	
	public String getProductId() {
		return this.productId;
	}
	
	public void setProductId(String productId) {
		this.productId = productId;
	}
	
	public String getFactoryName() {
		return this.factoryName;
	}
	
	public void setFactoryName(String factoryName) {
		this.factoryName = factoryName;
	}
	
	public String getProductLayout() {
		return this.productLayout;
	}
	
	public void setProductLayout(String productLayout) {
		this.productLayout = productLayout;
	}
	
	public String getProductEnglishName() {
		return this.productEnglishName;
	}
	
	public void setProductEnglishName(String productEnglishName) {
		this.productEnglishName = productEnglishName;
	}
	
	public String getProductShortName() {
		return this.productShortName;
	}
	
	public void setProductShortName(String productShortName) {
		this.productShortName = productShortName;
	}
	
	public String getBackProductFaceId() {
		return this.backProductFaceId;
	}
	
	public void setBackProductFaceId(String backProductFaceId) {
		this.backProductFaceId = backProductFaceId;
	}
	
	public String getRightProductFaceId() {
		return this.rightProductFaceId;
	}
	
	public void setRightProductFaceId(String rightProductFaceId) {
		this.rightProductFaceId = rightProductFaceId;
	}
	
	public String getProductSubstrate() {
		return this.productSubstrate;
	}
	
	public void setProductSubstrate(String productSubstrate) {
		this.productSubstrate = productSubstrate;
	}
	
	public String getMaterialCode() {
		return this.materialCode;
	}
	
	public void setMaterialCode(String materialCode) {
		this.materialCode = materialCode;
	}
	
	public String getProductCode() {
		return this.productCode;
	}
	
	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}
	
	public String getProductEnCode() {
		return this.productEnCode;
	}
	
	public void setProductEnCode(String productEnCode) {
		this.productEnCode = productEnCode;
	}
	
	public String getBodyColor() {
		return this.bodyColor;
	}
	
	public void setBodyColor(String bodyColor) {
		this.bodyColor = bodyColor;
	}
	
	public String getCustomerMaterialCode() {
		return this.customerMaterialCode;
	}
	
	public void setCustomerMaterialCode(String customerMaterialCode) {
		this.customerMaterialCode = customerMaterialCode;
	}
	
	public String getVersionNo() {
		return this.versionNo;
	}
	
	public void setVersionNo(String versionNo) {
		this.versionNo = versionNo;
	}
	
	public String getIsNewSpecification() {
		return this.isNewSpecification;
	}
	
	public void setIsNewSpecification(String isNewSpecification) {
		this.isNewSpecification = isNewSpecification;
	}
	
	public String getSpecificationNo() {
		return this.specificationNo;
	}
	
	public void setSpecificationNo(String specificationNo) {
		this.specificationNo = specificationNo;
	}
}
