package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 产品类别
 * @TableName product_category
 */
@Table(name="product_category")
@Data
@Entity
public class ProductCategory implements Serializable {
    /**
     * 产品类别ID
     */
    @Id
    @Column(name = "product_category_id")
    private String productCategoryId;

    /**
     * 产品类别名称
     */
    @Column(name = "product_category_name")
    private String productCategoryName;

    /**
     * 产品类别状态(product_category_status)
     */
    @Column(name = "product_category_status")
    private String productCategoryStatus;

    /**
     * 产品编码
     */
    @Column(name = "product_category_code")
    private String productCategoryCode;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        ProductCategory other = (ProductCategory) that;
        return (this.getProductCategoryId() == null ? other.getProductCategoryId() == null : this.getProductCategoryId().equals(other.getProductCategoryId()))
            && (this.getProductCategoryName() == null ? other.getProductCategoryName() == null : this.getProductCategoryName().equals(other.getProductCategoryName()))
            && (this.getProductCategoryStatus() == null ? other.getProductCategoryStatus() == null : this.getProductCategoryStatus().equals(other.getProductCategoryStatus()))
            && (this.getProductCategoryCode() == null ? other.getProductCategoryCode() == null : this.getProductCategoryCode().equals(other.getProductCategoryCode()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getProductCategoryId() == null) ? 0 : getProductCategoryId().hashCode());
        result = prime * result + ((getProductCategoryName() == null) ? 0 : getProductCategoryName().hashCode());
        result = prime * result + ((getProductCategoryStatus() == null) ? 0 : getProductCategoryStatus().hashCode());
        result = prime * result + ((getProductCategoryCode() == null) ? 0 : getProductCategoryCode().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", productCategoryId=").append(productCategoryId);
        sb.append(", productCategoryName=").append(productCategoryName);
        sb.append(", productCategoryStatus=").append(productCategoryStatus);
        sb.append(", productCategoryCode=").append(productCategoryCode);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}