package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 生产工厂
 * @TableName factory
 */
@Table(name="factory")
@Data
@Entity
public class Factory implements Serializable {
    /**
     * 工厂ID
     */
    @Id
    @Column(name = "factory_id")
    private String factoryId;

    /**
     * 工厂名称
     */
    @Column(name = "factory_name")
    private String factoryName;

    /**
     * 工厂编码
     */
    @Column(name = "factory_code")
    private String factoryCode;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        Factory other = (Factory) that;
        return (this.getFactoryId() == null ? other.getFactoryId() == null : this.getFactoryId().equals(other.getFactoryId()))
            && (this.getFactoryName() == null ? other.getFactoryName() == null : this.getFactoryName().equals(other.getFactoryName()))
            && (this.getFactoryCode() == null ? other.getFactoryCode() == null : this.getFactoryCode().equals(other.getFactoryCode()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getFactoryId() == null) ? 0 : getFactoryId().hashCode());
        result = prime * result + ((getFactoryName() == null) ? 0 : getFactoryName().hashCode());
        result = prime * result + ((getFactoryCode() == null) ? 0 : getFactoryCode().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", factoryId=").append(factoryId);
        sb.append(", factoryName=").append(factoryName);
        sb.append(", factoryCode=").append(factoryCode);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}