package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;

/**
 * 颜色
 * @TableName color
 */
@Table(name="color")
@Data
@Entity
public class Color implements Serializable {
    /**
     * 颜色ID
     */
    @Id
    @Column(name = "color_id")
    private String colorId;

    /**
     * 颜色名称
     */
    @Column(name = "color_name")
    private String colorName;

    /**
     * 颜色编码
     */
    @Column(name = "color_code")
    private String colorCode;

    /**
     * 备注
     */
    @Column(name = "color_remark")
    private String colorRemark;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        Color other = (Color) that;
        return (this.getColorId() == null ? other.getColorId() == null : this.getColorId().equals(other.getColorId()))
            && (this.getColorName() == null ? other.getColorName() == null : this.getColorName().equals(other.getColorName()))
            && (this.getColorCode() == null ? other.getColorCode() == null : this.getColorCode().equals(other.getColorCode()))
            && (this.getColorRemark() == null ? other.getColorRemark() == null : this.getColorRemark().equals(other.getColorRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getColorId() == null) ? 0 : getColorId().hashCode());
        result = prime * result + ((getColorName() == null) ? 0 : getColorName().hashCode());
        result = prime * result + ((getColorCode() == null) ? 0 : getColorCode().hashCode());
        result = prime * result + ((getColorRemark() == null) ? 0 : getColorRemark().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", colorId=").append(colorId);
        sb.append(", colorName=").append(colorName);
        sb.append(", colorCode=").append(colorCode);
        sb.append(", colorRemark=").append(colorRemark);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}