package com.huigou.topsun.product.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.cache.DictUtil;
import com.huigou.topsun.product.application.ProductApplication;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * ProductController
 *
 * @author qinzhenguan
 * @createDate 2023/11/27 11:19
 **/
@Controller
@ControllerMapping("/product")
public class ProductController extends CommonController {

    @Autowired
    private ProductApplication productService;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/product/";
    }

    /**
     * description 
     * @author qinzhenguan
     * @createDate 2023/11/27 11:49
     * @return null
     */
    public String findProduct() {//需要特定类型返回值
        ArrayList<Map<String,Object>> productPage = productService.findProductPage(0, 30);
        HashMap<Object, Object> map = new HashMap<>(3);
        map.put("Rows",productPage);
        return toResult(map);
    }

    public String queryDetailAll() {
        SDO sdo = this.getSDO();
        String productId = sdo.getString("id");
        Map<String, Object> map = productService.queryDetailAll(Integer.parseInt(productId));
        return toResult(map);
    }

    public String forwardProduct() {
        // 通过此方法可以查看系统配置的 字典 的数据结构
        DictUtil.getDictionaryList("technologyType");
        Map<String, Object> map4 = new HashMap<>(10);
        map4.put("六六六", "666");
        map4.put("七七七", "777");
        map4.put("八八八", "888");
        this.putAttribute("selectedCategory", map4);
        return forward("product");
    }

    public  String forwardProductDetail() {
        ObjectMapper mapper = new ObjectMapper();
        SDO sdo = this.getSDO();
        HashMap<String, Object> param;
        try {
            param = mapper.readValue(sdo.getString("data"), new TypeReference<HashMap<String, Object>>() {});
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return forward("productDetail", param);
    }

    public String loadProductDetail() {
        SDO sdo = this.getSDO();
        String productId = sdo.getString("productId");
        Map<String, Object> resultMap = productService.queryDetailAll(Integer.parseInt(productId));
        return toResult(resultMap);
    }

    public String saveProductAndDetail() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        SDO sdo = this.getSDO();
        String updateJson = sdo.toString();
        HashMap<String,Object> updateMap = mapper.readValue(updateJson, new TypeReference<HashMap<String,Object>>() {});
        HashMap<String,Object> rawMap = mapper.readValue(updateMap.get("rawData") + "", new TypeReference<HashMap<String,Object>>() {});
        updateMap.remove("rawData");

        HashMap<String,Object> resultMap = productService.saveProductAndDetail(rawMap, updateMap);
        return success(resultMap);
    }



}