var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadTechnologyListGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadTechnologyListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#technologyListGrid", {
        columns: [
            {display: "工艺路线名称", name: "technologyName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "产品ID", name: "productId", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "工艺版本", name: "technologyVersion", width: 120, minWidth: 60, type: "string", align: "left"},
            {
                display: "工艺类型",
                name: "technologyTypeTextView",
                width: 100,
                minWidth: 60,
                type: "string",
                align: "left"
            },
        ],
        dataAction: "server",
        url: web_app.name + '/technology/slicedTechnologyList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    /*UICtrl.showAjaxDialog({
        url: web_app.name + '/technology/addTechnologyDetail.load',
        title: "新增工艺设置",
        width: 1000,
        ok: function (div) {
            var _self = this;
            $('#submitForm', div).ajaxSubmit({
                url: web_app.name + '/technology/saveTechnology.ajax',
                param: {
                    processList: getProcessList(),
                },
                success: function () {
                    _self.close();
                    reloadGrid();
                }
            });
        }
    });*/
    UICtrl.addTabItem({
        tabid: 'technologyDetail',
        text: "新增工艺",
        url: web_app.name + '/technology/addTechnologyDetail.do'
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    /*UICtrl.showAjaxDialog({
        url: web_app.name + '/technology/showTechnologyDetail.load',
        title: "修改工艺设置",
        width: 1000,
        param: {technologyId: row.technologyId},
        ok: function (div) {
            var _self = this;
            $('#submitForm', div).ajaxSubmit({
                url: web_app.name + '/technology/updateTechnology.ajax',
                param: {
                    processList: getProcessList(),
                },
                success: function () {
                    _self.close();
                    reloadGrid();
                }
            });
        }
    });*/
    UICtrl.addTabItem({
        tabid: 'technologyDetail',
        text: "新增工艺",
        url: web_app.name + '/technology/showTechnologyDetail.do?technologyId='+row.technologyId
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'technology/deleteTechnologyByTechnologyId.ajax',
        gridManager: gridManager, idFieldName: 'technologyId',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function getProcessList() {
    var processList = null;
    var processManager = UICtrl.getGridManager('#processListGrid');
    if (processManager) {
        processList = DataUtil.getGridData({
            gridManager: processManager,
            isAllData: true
        });
        processList = Public.encodeJSONURI(processList);
    }
    return processList;
}

