var resourceGridManager = null ,processMaterialGridManager=null;

$(document).ready(function() {
	initializateUI();
	loadResourceGrid();
	loadProcessMaterialGrid();
});


function initializateUI() {
	UICtrl.layout("#layout", {leftWidth: 3});  
}

function loadResourceGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler: function(){
			UICtrl.addGridRow(resourceGridManager);
		},
		deleteHandler: function (){
			var _grid = UICtrl.getGridManager('#rsourceGrid');
			DataUtil.delSelectedRows({
				action: 'processResource/deleteProcessResource.ajax',
				param: {},
				gridManager: _grid,
				idFieldName: 'processResourceId',
				onSuccess: function () {
					reloadResourceGrid();
				}
			});
		},
	});
	resourceGridManager =  UICtrl.grid("#rsourceGrid", {
        columns: [
                  { display: "资源名称", name: "resourceName", width: 200, minWidth: 60, type: "string", align: "left",
					  editor: {
						  required: true, type: "select",
						  data: {
							  type: 'system',
							  name: "resourceSelect",
							  back: {
								  resourceId: "resourceId",
								  resourceName:"resourceName",
								  version:"version",
							  }
						  },
					  }
				  },
                  { display: "版本", name: "version", width: 200, minWidth: 60, type: "string", align: "left" },
                  ],
        dataAction: "server",
     	url: web_app.name + '/processResource/slicedProcessResourceList.ajax',
     	pageSize: 20,
     	usePager: true,
     	toolbar: toolbarOptions,
		enabledEdit: true,
     	width: "100%",
     	height: "100%",
     	heightDiff: -8,
     	checkbox: true,
     	fixedCellHeight: true,
     	selectRowButtonOnly: true,
     	onDblClickRow : function(data, rowindex, rowobj) {
			//updateHandler(data);
		}
    });
    UICtrl.setSearchAreaToggle(resourceGridManager);
}

function reloadResourceGrid() {
	resourceGridManager.loadData();
}

function loadProcessMaterialGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		addHandler: function(){
			UICtrl.addGridRow(processMaterialGridManager);
		},
		deleteHandler: function (){
			var _grid = UICtrl.getGridManager('#processMaterialGrid');
			DataUtil.delSelectedRows({
				action: 'processMaterialItem/deleteProcessMaterialItem.ajax',
				param: {},
				gridManager: _grid,
				idFieldName: 'processMaterialItemId',
				onSuccess: function () {
					reloadProcessMaterialGrid();
				}
			});
		},
	});
	processMaterialGridManager =  UICtrl.grid("#processMaterialGrid", {
		columns: [
			{ display: "物料名称", name: "materialName", width: 200, minWidth: 60, type: "string", align: "left",
				editor: {
					required: true, type: "select",
					data: {
						type: 'system',
						name: "sapMaterialSelect",
						back: {
							materialId: "materialId",
							materialName:"materialName",
							materialUnit:"materialUnit",
							materialJson:"materialJson",
						}
					},
				}
			},
			{ display: "物料计量单位", name: "materialUnit", width: 100, minWidth: 60, type: "string", align: "left" },
			{ display: "使用物料数量", name: "materialNumber", width: 100, minWidth: 60, type: "string", align: "left" ,
				editor: {
					type: 'text',
					mask: 'positiveMoney',
					required: true
				}
			},
			{ display: "物料相关内容", name: "materialJson", width: 400, minWidth: 60, type: "string", align: "left" },
		],
		dataAction: "server",
		url: web_app.name + '/processMaterialItem/slicedProcessMaterialItems.ajax',
		pageSize: 20,
		usePager: true,
		toolbar: toolbarOptions,
		enabledEdit: true,
		width: "100%",
		height: "100%",
		heightDiff: -8,
		checkbox: true,
		fixedCellHeight: true,
		selectRowButtonOnly: true,
		onDblClickRow : function(data, rowindex, rowobj) {
			//updateHandler(data);
		}
	});
	UICtrl.setSearchAreaToggle(processMaterialGridManager);
}
function reloadProcessMaterialGrid() {
	processMaterialGridManager.loadData();
}


